/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.as2.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.as2.api.entity.DispositionNotificationMultipartReportEntity;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.quarkus.component.as2.it.As2CertificateHelper;
import org.apache.camel.quarkus.component.as2.it.transport.ClientResult;
import org.apache.camel.quarkus.component.as2.it.transport.Request;
import org.apache.camel.quarkus.component.as2.it.transport.ServerResult;
import org.apache.http.protocol.HttpCoreContext;
import org.jboss.logging.Logger;

@Path(value="/as2")
@ApplicationScoped
public class As2Resource {
    public static String CLIENT_PORT_PARAMETER = As2Resource.class.getSimpleName() + "-client-port";
    public static String SERVER_PORT_PARAMETER = As2Resource.class.getSimpleName() + "-server-port";
    private static final Logger LOG = Logger.getLogger(As2Resource.class);
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/client")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ClientResult client(Request request) throws Exception {
        LOG.infof("Sending to as2: %s", request.getHeaders());
        As2CertificateHelper.setup();
        Object response = this.producerTemplate.requestBodyAndHeaders(this.getClientEndpoint(), (Object)request.getEdiMessage(), request.collectHeaders());
        ClientResult clientResult = new ClientResult();
        if (response instanceof DispositionNotificationMultipartReportEntity) {
            clientResult.setDispositionNotificationMultipartReportEntity(true);
            clientResult.setPartsCount(((DispositionNotificationMultipartReportEntity)response).getPartCount());
            if (clientResult.getPartsCount() > 1) {
                clientResult.setSecondPartClassName(((DispositionNotificationMultipartReportEntity)response).getPart(1).getClass().getSimpleName());
            }
        } else if (response instanceof MultipartSignedEntity) {
            clientResult.setMultipartSignedEntity(true);
            MimeEntity responseSignedDataEntity = ((MultipartSignedEntity)response).getSignedDataEntity();
            clientResult.setPartsCount(((DispositionNotificationMultipartReportEntity)responseSignedDataEntity).getPartCount());
            if (clientResult.getPartsCount() > 1) {
                clientResult.setSecondPartClassName(((DispositionNotificationMultipartReportEntity)responseSignedDataEntity).getPart(1).getClass().getSimpleName());
            }
            clientResult.setSignedEntityReceived(((MultipartSignedEntity)response).getSignatureEntity() != null);
        }
        LOG.infof("Got response from as2: %s", response);
        return clientResult;
    }

    @Path(value="/serverInit")
    @GET
    @Produces(value={"application/json"})
    public boolean serverInit() throws Exception {
        LOG.info((Object)"Initializing server from as2 component.");
        this.consumerTemplate.receiveNoWait(this.getServerEndpoint());
        return true;
    }

    @Path(value="/server")
    @GET
    @Produces(value={"application/json"})
    public ServerResult server() throws Exception {
        LOG.info((Object)"Receiving from as2.");
        Exchange exchange = this.consumerTemplate.receive(this.getServerEndpoint());
        if (exchange == null) {
            return null;
        }
        ServerResult serverResult = new ServerResult();
        serverResult.setResult((String)exchange.getIn().getBody(String.class));
        HttpCoreContext coreContext = (HttpCoreContext)exchange.getProperty("CamelAS2.interchange", HttpCoreContext.class);
        if (coreContext != null) {
            serverResult.setRequestClass(coreContext.getRequest().getClass().getSimpleName());
        }
        return serverResult;
    }

    private String getServerEndpoint() {
        String url = String.format("as2://server/listen?serverPortNumber=%s&clientFqdn=%s&requestUriPattern=/", System.getProperty(SERVER_PORT_PARAMETER), "example.com");
        return url;
    }

    private String getClientEndpoint() {
        String url = String.format("as2://client/send?inBody=ediMessage&targetPortNumber=%s&targetHostname=%s", System.getProperty(CLIENT_PORT_PARAMETER), "localhost");
        return url;
    }
}

