/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.arangodb.it;

import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.DocumentCreateEntity;
import com.arangodb.entity.DocumentDeleteEntity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Path(value="/arangodb")
@ApplicationScoped
public class ArangodbResource {
    private static final Logger LOG = Logger.getLogger(ArangodbResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    @ConfigProperty(name="camel.arangodb.host")
    String host;
    @ConfigProperty(name="camel.arangodb.port")
    String port;

    @PUT
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response put(String message) throws Exception {
        LOG.infof("Saving to arangodb: %s", (Object)message);
        DocumentCreateEntity response = (DocumentCreateEntity)this.producerTemplate.requestBody(String.format("arangodb:test?host=%s&port=%s&documentCollection=camel&operation=SAVE_DOCUMENT", this.host, this.port), (Object)this.toDocument(message), DocumentCreateEntity.class);
        LOG.infof("Got response from arangodb: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getKey()).build();
    }

    @Path(value="{key}")
    @GET
    @Produces(value={"text/plain"})
    public Response get(@PathParam(value="key") String key) throws Exception {
        LOG.infof("Retrieve document from arangodb with key: %s", (Object)key);
        BaseDocument response = (BaseDocument)this.producerTemplate.requestBodyAndHeader("arangodb:test?host={{camel.arangodb.host}}&port={{camel.arangodb.port}}&documentCollection=camel&operation=FIND_DOCUMENT_BY_KEY", (Object)key, "ResultClassType", BaseDocument.class, BaseDocument.class);
        LOG.infof("Got response from arangodb: %s", (Object)response);
        return Response.ok().entity((Object)this.toString(response)).build();
    }

    @Path(value="{key}")
    @DELETE
    public Response delete(@PathParam(value="key") String key) throws Exception {
        LOG.infof("Delete document from arangodb with key : %s", (Object)key);
        this.producerTemplate.requestBody("arangodb:test?host={{camel.arangodb.host}}&port={{camel.arangodb.port}}&documentCollection=camel&operation=DELETE_DOCUMENT", (Object)key, DocumentDeleteEntity.class);
        return Response.ok().build();
    }

    @Path(value="{key}")
    @POST
    @Consumes(value={"text/plain"})
    public Response post(@PathParam(value="key") String key, String msg) throws Exception {
        LOG.infof("Update document from arangodb with key : %s", (Object)key);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("ResultClassType", String.class);
        headers.put("key", key);
        this.producerTemplate.requestBodyAndHeaders("arangodb:test?host={{camel.arangodb.host}}&port={{camel.arangodb.port}}&documentCollection=camel&operation=UPDATE_DOCUMENT", (Object)this.toDocument(msg), headers, String.class);
        return Response.ok().build();
    }

    @Path(value="/foo/{fooName}")
    @GET
    @Produces(value={"text/plain"})
    public Response getByFooName(@PathParam(value="fooName") String fooName) throws Exception {
        LOG.infof("Retrieve document from arangodb with foo: %s", (Object)fooName);
        String query = "FOR t IN camel FILTER t.foo == @foo RETURN t";
        Map<String, String> bindVars = Map.of("foo", fooName);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelArangoDbAqlQuery", query);
        headers.put("CamelArangoDbAqlParameters", bindVars);
        headers.put("CamelArangoDbAqlOptions", null);
        headers.put("ResultClassType", Map.class);
        List o = (List)this.producerTemplate.requestBodyAndHeaders("arangodb:test?host={{camel.arangodb.host}}&port={{camel.arangodb.port}}&operation=AQL_QUERY", (Object)fooName, headers, List.class);
        return Response.ok().entity((Object)this.toString(o)).build();
    }

    private BaseDocument toDocument(String msg) {
        BaseDocument myObject = new BaseDocument();
        Arrays.stream(msg.split(",")).map(pair -> pair.split(":")).forEach(strings -> myObject.addAttribute(strings[0], (Object)strings[1]));
        return myObject;
    }

    private String toString(Object o) {
        if (o instanceof List && ((List)o).size() == 1 && ((List)o).get(0) instanceof Map) {
            return this.toString(((List)o).get(0));
        }
        if (o instanceof Map) {
            return ((Map)o).entrySet().stream().map(e -> String.valueOf(((Map.Entry)e).getKey()) + ":" + String.valueOf(((Map.Entry)e).getValue())).collect(Collectors.joining(","));
        }
        if (o instanceof BaseDocument) {
            return this.toString(((BaseDocument)o).getProperties());
        }
        return o.toString();
    }
}

