/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.arangodb.it;

import com.github.dockerjava.api.model.Ulimit;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import org.apache.camel.util.CollectionHelper;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class ArangodbTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArangodbTestResource.class);
    private GenericContainer<?> container;
    private static final String CONTAINER_NAME = "arango";
    private static final String ARANGO_IMAGE = (String)ConfigProvider.getConfig().getValue("arangodb.container.image", String.class);
    private static final String ARANGO_NO_AUTH = "ARANGO_NO_AUTH";
    private static final Integer PORT_DEFAULT = 8529;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = new GenericContainer(ARANGO_IMAGE).withExposedPorts(new Integer[]{PORT_DEFAULT}).withEnv(ARANGO_NO_AUTH, "1").withNetworkAliases(new String[]{CONTAINER_NAME}).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*ArangoDB [(]version .*[)] is ready for business. Have fun!.*", (int)1)).withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withUlimits(new Ulimit[]{new Ulimit("nofile", 65535L, 65535L)}));
            this.container.start();
            return CollectionHelper.mapOf((Object)"camel.arangodb.port", (Object)this.container.getMappedPort(PORT_DEFAULT.intValue()).toString(), (Object[])new Object[]{"camel.arangodb.host", this.container.getHost()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

