/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.arangodb.it;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoDB;
import com.arangodb.ArangoDatabase;
import com.arangodb.entity.BaseDocument;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.arangodb.it.ArangodbTestResource;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=ArangodbTestResource.class)
class ArangodbTest {
    protected static final String DATABASE_NAME = "test";
    protected static final String COLLECTION_NAME = "camel";
    protected static ArangoDB arangoDb;
    protected static ArangoCollection collection;

    ArangodbTest() {
    }

    @Test
    public void testCreateGetDeleteDocument() {
        String key = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("foo:bar").put("/arangodb", new Object[0])).then()).statusCode(201)).extract().body().asString();
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/arangodb/" + key), (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.containsString((String)"foo:bar"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).delete("/arangodb/" + key, new Object[0])).then()).statusCode(200);
        BaseDocument documentDeleted = (BaseDocument)collection.getDocument(key, BaseDocument.class);
        Assertions.assertNull((Object)documentDeleted);
    }

    @Test
    public void testUpdateDocument() {
        BaseDocument myObject = new BaseDocument();
        myObject.setKey("myKey");
        myObject.addAttribute("foo", (Object)"bar");
        collection.insertDocument((Object)myObject);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("key:myKey,foo:hello,gg:42").post("/arangodb/myKey", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/arangodb/myKey", (Object[])new Object[0]).then()).statusCode(200)).body((Matcher)Matchers.both((Matcher)Matchers.containsString((String)"foo:hello")).and(Matchers.containsString((String)"gg:42")), new Matcher[0]);
    }

    @Test
    public void testAQLQuery() {
        BaseDocument myObject1 = new BaseDocument();
        myObject1.setKey("keyBar1");
        myObject1.addAttribute("foo", (Object)"bar1");
        collection.insertDocument((Object)myObject1);
        BaseDocument myObject2 = new BaseDocument();
        myObject2.setKey("keyBar2");
        myObject2.addAttribute("foo", (Object)"bar2");
        collection.insertDocument((Object)myObject2);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/arangodb/foo/bar1", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.containsString((String)"_key:keyBar1"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/arangodb/foo/bar2", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.containsString((String)"_key:keyBar2"), new Matcher[0]);
    }

    @BeforeAll
    public static void setup() {
        String host = (String)ConfigProvider.getConfig().getValue("camel.arangodb.host", String.class);
        Integer port = (Integer)ConfigProvider.getConfig().getValue("camel.arangodb.port", Integer.class);
        arangoDb = ((ArangoDB.Builder)new ArangoDB.Builder().host(host, port.intValue())).build();
        arangoDb.createDatabase(DATABASE_NAME);
        ArangoDatabase arangoDatabase = arangoDb.db(DATABASE_NAME);
        arangoDatabase.createCollection(COLLECTION_NAME);
        collection = arangoDatabase.collection(COLLECTION_NAME);
    }

    @AfterAll
    public static void teardown() {
        arangoDb.shutdown();
    }
}

