/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.arangodb.it;

import com.arangodb.entity.DocumentCreateEntity;
import com.arangodb.entity.DocumentDeleteEntity;
import com.arangodb.util.MapBuilder;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/arangodb/camel")
@ApplicationScoped
public class ArangodbResource {
    private static final Logger LOG = Logger.getLogger(ArangodbResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @PUT
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response put(String message) throws Exception {
        LOG.infof("Saving to arangodb: %s", (Object)message);
        DocumentCreateEntity response = (DocumentCreateEntity)this.producerTemplate.requestBody("arangodb:test?host={{camel.arangodb.host}}&port={{camel.arangodb.port}}&documentCollection=camel&operation=SAVE_DOCUMENT", (Object)message, DocumentCreateEntity.class);
        LOG.infof("Got response from arangodb: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getKey()).build();
    }

    @Path(value="{key}")
    @GET
    @Produces(value={"text/plain"})
    public Response get(@PathParam(value="key") String key) throws Exception {
        LOG.infof("Retrieve document from arangodb with key: %s", (Object)key);
        String response = (String)this.producerTemplate.requestBodyAndHeader("arangodb:test?host={{camel.arangodb.host}}&port={{camel.arangodb.port}}&documentCollection=camel&operation=FIND_DOCUMENT_BY_KEY", (Object)key, "ResultClassType", String.class, String.class);
        LOG.infof("Got response from arangodb: %s", (Object)response);
        return Response.ok().entity((Object)response).build();
    }

    @Path(value="{key}")
    @DELETE
    public Response delete(@PathParam(value="key") String key) throws Exception {
        LOG.infof("Delete document from arangodb with key : %s", (Object)key);
        this.producerTemplate.requestBody("arangodb:test?host={{camel.arangodb.host}}&port={{camel.arangodb.port}}&documentCollection=camel&operation=DELETE_DOCUMENT", (Object)key, DocumentDeleteEntity.class);
        return Response.ok().build();
    }

    @Path(value="{key}")
    @POST
    @Consumes(value={"text/plain"})
    public Response post(@PathParam(value="key") String key, String msg) throws Exception {
        LOG.infof("Update document from arangodb with key : %s", (Object)key);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("ResultClassType", String.class);
        headers.put("key", key);
        this.producerTemplate.requestBodyAndHeaders("arangodb:test?host={{camel.arangodb.host}}&port={{camel.arangodb.port}}&documentCollection=camel&operation=UPDATE_DOCUMENT", (Object)msg, headers, String.class);
        return Response.ok().build();
    }

    @Path(value="/foo/{fooName}")
    @GET
    @Produces(value={"text/plain"})
    public Response getByFooName(@PathParam(value="fooName") String fooName) throws Exception {
        LOG.infof("Retrieve document from arangodb with foo: %s", (Object)fooName);
        String query = "FOR t IN camel FILTER t.foo == @foo RETURN t";
        Map bindVars = new MapBuilder().put("foo", (Object)fooName).get();
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelArangoDbAqlQuery", query);
        headers.put("CamelArangoDbAqlParameters", bindVars);
        headers.put("CamelArangoDbAqlOptions", null);
        headers.put("ResultClassType", String.class);
        Collection responseList = (Collection)this.producerTemplate.requestBodyAndHeaders("arangodb:test?host={{camel.arangodb.host}}&port={{camel.arangodb.port}}&operation=AQL_QUERY", (Object)fooName, headers, Collection.class);
        return Response.ok().entity((Object)responseList.toString()).build();
    }
}

