/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.arangodb.it;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoDB;
import com.arangodb.ArangoDatabase;
import com.arangodb.entity.BaseDocument;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import org.apache.camel.quarkus.component.arangodb.it.ArangodbTestResource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=ArangodbTestResource.class)
class ArangodbTest {
    protected static final String DATABASE_NAME = "test";
    protected static final String COLLECTION_NAME = "camel";
    protected static ArangoDB arangoDb;
    protected static ArangoCollection collection;

    ArangodbTest() {
    }

    @Test
    public void testCreateGetDeleteDocument() {
        RequestSpecification request = RestAssured.given().contentType(ContentType.TEXT).body("{\"foo\":\"bar\"}");
        Response response = (Response)request.put("/arangodb/camel", new Object[0]);
        int statusCode = response.getStatusCode();
        Assertions.assertEquals((int)201, (int)statusCode);
        String key = response.body().asString().trim();
        request = RestAssured.given().contentType(ContentType.TEXT);
        response = (Response)request.get("/arangodb/camel/" + key, new Object[0]);
        statusCode = response.getStatusCode();
        Assertions.assertEquals((int)200, (int)statusCode);
        String document = response.body().asString().trim();
        Assertions.assertTrue((boolean)document.contains("\"foo\":\"bar\""));
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).delete("/arangodb/camel/" + key, new Object[0])).then()).statusCode(200);
        BaseDocument documentDeleted = (BaseDocument)collection.getDocument(key, BaseDocument.class);
        Assertions.assertNull((Object)documentDeleted);
    }

    @Test
    public void testUpdateDocument() {
        BaseDocument myObject = new BaseDocument();
        myObject.setKey("myKey");
        myObject.addAttribute("foo", (Object)"bar");
        collection.insertDocument((Object)myObject);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("{\"key\":\"myKey\",\"foo\":\"hello\", \"gg\":\"42\"}").post("/arangodb/camel/myKey", new Object[0])).then()).statusCode(200);
        RequestSpecification request = RestAssured.given().contentType(ContentType.TEXT);
        Response response = (Response)request.get("/arangodb/camel/myKey", new Object[0]);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        String document = response.body().asString().trim();
        Assertions.assertTrue((boolean)document.contains("\"foo\":\"hello\""));
        Assertions.assertTrue((boolean)document.contains("\"gg\":\"42\""));
    }

    @Test
    public void testAQLQuery() {
        BaseDocument myObject1 = new BaseDocument();
        myObject1.setKey("keyBar1");
        myObject1.addAttribute("foo", (Object)"bar1");
        collection.insertDocument((Object)myObject1);
        BaseDocument myObject2 = new BaseDocument();
        myObject2.setKey("keyBar2");
        myObject2.addAttribute("foo", (Object)"bar2");
        collection.insertDocument((Object)myObject2);
        RequestSpecification request = RestAssured.given().contentType(ContentType.TEXT);
        Response response = (Response)request.get("/arangodb/camel/foo/bar1", new Object[0]);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        String result = response.body().asString();
        Assertions.assertTrue((boolean)result.contains("\"_key\":\"keyBar1\""));
        request = RestAssured.given().contentType(ContentType.TEXT);
        response = (Response)request.get("/arangodb/camel/foo/bar2", new Object[0]);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        result = response.body().asString().trim();
        Assertions.assertTrue((boolean)result.contains("\"_key\":\"keyBar2\""));
    }

    @BeforeAll
    public static void setup() {
        String host = System.getProperty("camel.arangodb.host");
        Integer port = Integer.valueOf(System.getProperty("camel.arangodb.port"));
        arangoDb = new ArangoDB.Builder().host(host, port.intValue()).build();
        arangoDb.createDatabase(DATABASE_NAME);
        ArangoDatabase arangoDatabase = arangoDb.db(DATABASE_NAME);
        arangoDatabase.createCollection(COLLECTION_NAME);
        collection = arangoDatabase.collection(COLLECTION_NAME);
    }

    @AfterAll
    public static void teardown() {
        arangoDb.shutdown();
    }
}

