/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.amqp.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class ActiveMQTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveMQTestResource.class);
    private static final String ACTIVEMQ_IMAGE = "vromero/activemq-artemis:2.11.0-alpine";
    private static final String ACTIVEMQ_USERNAME = "artemis";
    private static final String ACTIVEMQ_PASSWORD = "simetraehcapa";
    private static final int AMQP_PORT = 5672;
    private GenericContainer container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = new GenericContainer(ACTIVEMQ_IMAGE).withExposedPorts(new Integer[]{5672}).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).withEnv("BROKER_CONFIG_MAX_DISK_USAGE", "100").waitingFor((WaitStrategy)Wait.forListeningPort());
            this.container.start();
            String brokerUrl = String.format("amqp://127.0.0.1:%d", this.container.getMappedPort(5672));
            return CollectionHelper.mapOf((Object)"quarkus.qpid-jms.url", (Object)brokerUrl, (Object[])new Object[]{"quarkus.qpid-jms.username", ACTIVEMQ_USERNAME, "quarkus.qpid-jms.password", ACTIVEMQ_PASSWORD});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

