/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.amqp.it;

import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;

@Path(value="/amqp")
public class AmqpResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/{queueName}")
    @GET
    @Produces(value={"text/plain"})
    public String consumeAmqpMessage(@PathParam(value="queueName") String queueName) {
        return (String)this.consumerTemplate.receiveBody("amqp:queue:" + queueName, 5000L, String.class);
    }

    @Path(value="/{queueName}")
    @POST
    @Consumes(value={"text/plain"})
    public Response produceAmqpMessage(@PathParam(value="queueName") String queueName, String message) throws Exception {
        this.producerTemplate.sendBody("amqp:queue:" + queueName, (Object)message);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }
}

