/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.activemq.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class ActiveMQTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveMQTestResource.class);
    private static final String ACTIVEMQ_IMAGE = "rmohr/activemq:5.15.9-alpine";
    private static final int TCP_PORT = 61616;
    private GenericContainer<?> container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = new GenericContainer(ACTIVEMQ_IMAGE).withExposedPorts(new Integer[]{61616}).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*ActiveMQ.*started.*", (int)1));
            this.container.start();
            return Collections.singletonMap("camel.component.activemq.broker-url", String.format("tcp://%s:%d", this.container.getContainerIpAddress(), this.container.getMappedPort(61616)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

