/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.influxdb.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.jboss.jandex.IndexView;

class InfluxdbProcessor {
    private static String INFLUXDB_DTO_PACKAGE = "org.influxdb.dto";
    private static final String FEATURE = "camel-influxdb";

    InfluxdbProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void sslSupport(BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport) {
        extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(FEATURE));
    }

    @BuildStep
    void clientProxies(BuildProducer<NativeImageProxyDefinitionBuildItem> proxies) {
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.influxdb.impl.InfluxDBService"}));
    }

    @BuildStep
    ReflectiveClassBuildItem registerForReflection(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        String[] dtos = (String[])index.getKnownClasses().stream().map(ci -> ci.name().toString()).filter(n -> n.startsWith(INFLUXDB_DTO_PACKAGE)).sorted().toArray(String[]::new);
        return new ReflectiveClassBuildItem(false, true, dtos);
    }

    @BuildStep
    IndexDependencyBuildItem registerDependencyForIndex() {
        return new IndexDependencyBuildItem("org.influxdb", "influxdb-java");
    }
}

