/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.ical.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceDirectoryBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import java.util.stream.Stream;
import net.fortuna.ical4j.model.TimeZoneLoader;
import net.fortuna.ical4j.util.MapTimeZoneCache;

class IcalProcessor {
    private static final String FEATURE = "camel-ical";

    IcalProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void nativeResources(BuildProducer<NativeImageResourceBuildItem> nativeResources, BuildProducer<NativeImageResourceDirectoryBuildItem> nativeResourceDirs) {
        nativeResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"net/fortuna/ical4j/model/tz.alias"}));
        Stream.of("zoneinfo/Africa", "zoneinfo/America", "zoneinfo/America/Argentina", "zoneinfo/America/Indiana", "zoneinfo/America/Kentucky", "zoneinfo/America/North_Dakota", "zoneinfo/Antarctica", "zoneinfo/Arctic", "zoneinfo/Asia", "zoneinfo/Atlantic", "zoneinfo/Australia", "zoneinfo/Europe", "zoneinfo/Indian", "zoneinfo/Pacific").forEach(path -> nativeResourceDirs.produce((BuildItem)new NativeImageResourceDirectoryBuildItem(path)));
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{MapTimeZoneCache.class}).build());
    }

    @BuildStep
    RuntimeReinitializedClassBuildItem runtimeReinitializedClasses() {
        return new RuntimeReinitializedClassBuildItem(TimeZoneLoader.class.getName());
    }
}

