/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.hl7.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.jboss.logging.Logger;

@Path(value="/hl7")
@ApplicationScoped
public class Hl7Resource {
    private static final Logger LOG = Logger.getLogger(Hl7Resource.class);
    private static final String DATAFORMAT_HL7 = "hl7";
    private static final String LANGUAGE_HL7TERSER = "hl7terser";
    @Inject
    CamelContext context;

    @Path(value="/load/dataformat/hl7")
    @GET
    @Produces(value={"text/plain"})
    public Response loadDataformatHl7() throws Exception {
        if (this.context.resolveDataFormat(DATAFORMAT_HL7) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", (Object)DATAFORMAT_HL7);
        return Response.status((int)500, (String)"hl7 could not be loaded from the Camel context").build();
    }

    @Path(value="/load/language/hl7terser")
    @GET
    @Produces(value={"text/plain"})
    public Response loadLanguageHl7terser() throws Exception {
        if (this.context.resolveLanguage(LANGUAGE_HL7TERSER) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", (Object)LANGUAGE_HL7TERSER);
        return Response.status((int)500, (String)"hl7terser could not be loaded from the Camel context").build();
    }
}

