/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.hbase.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import org.apache.camel.quarkus.component.hbase.it.HBaseTestResource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=HBaseTestResource.class)
class HbaseTest {
    HbaseTest() {
    }

    @Test
    public void e2e() throws IOException, InterruptedException {
        this.createTable("testtable", "family-1");
        ((ValidatableResponse)((Response)RestAssured.given().body("foo").post("/hbase/put/testtable/1/family-1/column-1", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/hbase/get/testtable", (Object[])new Object[0]).then()).statusCode(200)).body("rows.size()", Is.is((Object)1), new Object[]{"rows[0].id", Is.is((Object)"1"), "rows[0].cells.size()", Is.is((Object)1), "rows[0].cells[0].family", Is.is((Object)"family-1"), "rows[0].cells[0].qualifier", Is.is((Object)"column-1"), "rows[0].cells[0].value", Is.is((Object)"foo")});
    }

    protected void createTable(String name, byte[][] families) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)name));
        for (byte[] fam : families) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])fam));
        }
        this.connectHBase().getAdmin().createTable(builder.build());
    }

    protected void createTable(String name, String family) throws IOException {
        this.createTable(name, new byte[][]{family.getBytes()});
    }

    protected Connection connectHBase() throws IOException {
        Connection connection = ConnectionFactory.createConnection((Configuration)HbaseTest.defaultConf());
        return connection;
    }

    public static Configuration defaultConf() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("test.hbase.zookeeper.property.clientPort", HBaseTestResource.CLIENT_PORT.toString());
        return conf;
    }
}

