/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.hbase.it;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class HBaseTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOG = Logger.getLogger(HBaseTestResource.class);
    static final Integer CLIENT_PORT = 2181;
    private GenericContainer<?> container;

    public Map<String, String> start() {
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            Consumer<CreateContainerCmd> cmd = e -> {
                e.withPortBindings(new PortBinding[]{new PortBinding(Ports.Binding.bindPort((int)2181), new ExposedPort(2181)), new PortBinding(Ports.Binding.bindPort((int)16000), new ExposedPort(16000)), new PortBinding(Ports.Binding.bindPort((int)16020), new ExposedPort(16020))});
                e.withHostName(hostname);
            };
            this.container = new GenericContainer("dajobe/hbase:latest").withExposedPorts(new Integer[]{2181, 16000, 16020}).withCreateContainerCmdModifier(cmd).withLogConsumer(frame -> System.out.print(frame.getUtf8String())).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Finished refreshing block distribution cache for 2 regions\\n", (int)1));
            this.container.start();
            return Collections.emptyMap();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

