/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.hbase.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.jboss.logging.Logger;

public class HBaseTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOG = Logger.getLogger(HBaseTestResource.class);
    static final Integer CLIENT_PORT = 21818;
    private HBaseTestingUtility hbaseUtil;

    public Map<String, String> start() {
        try {
            Configuration conf = HBaseConfiguration.create();
            conf.set("test.hbase.zookeeper.property.clientPort", CLIENT_PORT.toString());
            this.hbaseUtil = new HBaseTestingUtility(conf);
            this.hbaseUtil.startMiniCluster(1);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start HBase cluster.", e);
        }
        return Collections.emptyMap();
    }

    public void stop() {
        try {
            this.hbaseUtil.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error shutting down the HBase container", (Throwable)e);
        }
    }
}

