/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.hbase.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicyFactory;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.security.JniBasedUnixGroupsMapping;

class HbaseProcessor {
    private static final String FEATURE = "camel-hbase";

    HbaseProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void initAtRuntime(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses) {
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(JniBasedUnixGroupsMapping.class.getName()));
    }

    @BuildStep
    void nativeResources(BuildProducer<NativeImageResourceBuildItem> nativeResources) {
        Stream.of("core-default.xml", "core-site.xml", "hbase-default.xml", "hbase-site.xml").map(xva$0 -> new NativeImageResourceBuildItem(new String[]{xva$0})).forEach(arg_0 -> nativeResources.produce(arg_0));
    }

    @BuildStep
    void refelectiveClasses(BuildProducer<ReflectiveClassBuildItem> refelectiveClasses) {
        refelectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{UserProvider.class.getName(), "org.apache.hadoop.hbase.client.ConnectionImplementation", ClientBackoffPolicyFactory.NoBackoffPolicy.class.getName(), "org.apache.hadoop.hbase.client.SimpleRequestController", "org.apache.hadoop.hbase.client.ClusterStatusListener$MulticastListener", "org.apache.hadoop.hbase.client.ZKAsyncRegistry", "org.apache.hadoop.hbase.ipc.NettyRpcClient", "org.apache.zookeeper.ClientCnxnSocketNIO", "org.apache.hadoop.hbase.codec.KeyValueCodec", "sun.security.provider.ConfigFile"}));
        refelectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"com.sun.security.auth.module.UnixLoginModule", "org.apache.hadoop.security.UserGroupInformation$HadoopLoginModule"}));
    }
}

