/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.hazelcast.deployment;

import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.topic.ITopic;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.naming.Context;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.TrustManager;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.tooling.model.MainModel;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

class HazelcastProcessor {
    private static final String FEATURE = "camel-hazelcast";

    HazelcastProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerReflectiveClasses() {
        ArrayList<ReflectiveClassBuildItem> items = new ArrayList<ReflectiveClassBuildItem>();
        items.add(new ReflectiveClassBuildItem(false, true, new String[]{"com.hazelcast.core.HazelcastInstance"}));
        items.add(new ReflectiveClassBuildItem(false, true, new String[]{"com.hazelcast.config.Config"}));
        items.add(new ReflectiveClassBuildItem(false, true, new String[]{"com.hazelcast.config.ClientConfig"}));
        return items;
    }

    @BuildStep
    void registerCustomImplementationClasses(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchies, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings) {
        HazelcastProcessor.registerTypeHierarchy(reflectiveClassHierarchies, ignoreWarnings, IList.class, IQueue.class, ISet.class, HazelcastInstance.class, IAtomicLong.class, IMap.class, MultiMap.class, ReplicatedMap.class, Ringbuffer.class, ITopic.class, MBeanServer.class, Context.class, KeyManager.class, SNIServerName.class, TrustManager.class, XPathFactory.class, MainModel.class);
    }

    private static void registerTypeHierarchy(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignoreWarnings, Class<?> ... classNames) {
        for (Class<?> klass : classNames) {
            DotName simpleName = DotName.createSimple((String)klass.getName());
            reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(Type.create((DotName)simpleName, (Type.Kind)Type.Kind.CLASS)).build());
            ignoreWarnings.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem(simpleName));
        }
    }
}

