package org.apache.camel.quarkus.component.grpc.it.model;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * The PingPong service definition.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.29.0)",
    comments = "Source: pingpong.proto")
public final class PingPongGrpc {

  private PingPongGrpc() {}

  public static final String SERVICE_NAME = "org.apache.camel.quarkus.component.grpc.it.model.PingPong";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<org.apache.camel.quarkus.component.grpc.it.model.PingRequest,
      org.apache.camel.quarkus.component.grpc.it.model.PongResponse> getPingSyncSyncMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PingSyncSync",
      requestType = org.apache.camel.quarkus.component.grpc.it.model.PingRequest.class,
      responseType = org.apache.camel.quarkus.component.grpc.it.model.PongResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.apache.camel.quarkus.component.grpc.it.model.PingRequest,
      org.apache.camel.quarkus.component.grpc.it.model.PongResponse> getPingSyncSyncMethod() {
    io.grpc.MethodDescriptor<org.apache.camel.quarkus.component.grpc.it.model.PingRequest, org.apache.camel.quarkus.component.grpc.it.model.PongResponse> getPingSyncSyncMethod;
    if ((getPingSyncSyncMethod = PingPongGrpc.getPingSyncSyncMethod) == null) {
      synchronized (PingPongGrpc.class) {
        if ((getPingSyncSyncMethod = PingPongGrpc.getPingSyncSyncMethod) == null) {
          PingPongGrpc.getPingSyncSyncMethod = getPingSyncSyncMethod =
              io.grpc.MethodDescriptor.<org.apache.camel.quarkus.component.grpc.it.model.PingRequest, org.apache.camel.quarkus.component.grpc.it.model.PongResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "PingSyncSync"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.camel.quarkus.component.grpc.it.model.PingRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.camel.quarkus.component.grpc.it.model.PongResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PingPongMethodDescriptorSupplier("PingSyncSync"))
              .build();
        }
      }
    }
    return getPingSyncSyncMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.camel.quarkus.component.grpc.it.model.PingRequest,
      org.apache.camel.quarkus.component.grpc.it.model.PongResponse> getPingSyncAsyncMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PingSyncAsync",
      requestType = org.apache.camel.quarkus.component.grpc.it.model.PingRequest.class,
      responseType = org.apache.camel.quarkus.component.grpc.it.model.PongResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<org.apache.camel.quarkus.component.grpc.it.model.PingRequest,
      org.apache.camel.quarkus.component.grpc.it.model.PongResponse> getPingSyncAsyncMethod() {
    io.grpc.MethodDescriptor<org.apache.camel.quarkus.component.grpc.it.model.PingRequest, org.apache.camel.quarkus.component.grpc.it.model.PongResponse> getPingSyncAsyncMethod;
    if ((getPingSyncAsyncMethod = PingPongGrpc.getPingSyncAsyncMethod) == null) {
      synchronized (PingPongGrpc.class) {
        if ((getPingSyncAsyncMethod = PingPongGrpc.getPingSyncAsyncMethod) == null) {
          PingPongGrpc.getPingSyncAsyncMethod = getPingSyncAsyncMethod =
              io.grpc.MethodDescriptor.<org.apache.camel.quarkus.component.grpc.it.model.PingRequest, org.apache.camel.quarkus.component.grpc.it.model.PongResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "PingSyncAsync"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.camel.quarkus.component.grpc.it.model.PingRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.camel.quarkus.component.grpc.it.model.PongResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PingPongMethodDescriptorSupplier("PingSyncAsync"))
              .build();
        }
      }
    }
    return getPingSyncAsyncMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.camel.quarkus.component.grpc.it.model.PingRequest,
      org.apache.camel.quarkus.component.grpc.it.model.PongResponse> getPingAsyncSyncMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PingAsyncSync",
      requestType = org.apache.camel.quarkus.component.grpc.it.model.PingRequest.class,
      responseType = org.apache.camel.quarkus.component.grpc.it.model.PongResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.CLIENT_STREAMING)
  public static io.grpc.MethodDescriptor<org.apache.camel.quarkus.component.grpc.it.model.PingRequest,
      org.apache.camel.quarkus.component.grpc.it.model.PongResponse> getPingAsyncSyncMethod() {
    io.grpc.MethodDescriptor<org.apache.camel.quarkus.component.grpc.it.model.PingRequest, org.apache.camel.quarkus.component.grpc.it.model.PongResponse> getPingAsyncSyncMethod;
    if ((getPingAsyncSyncMethod = PingPongGrpc.getPingAsyncSyncMethod) == null) {
      synchronized (PingPongGrpc.class) {
        if ((getPingAsyncSyncMethod = PingPongGrpc.getPingAsyncSyncMethod) == null) {
          PingPongGrpc.getPingAsyncSyncMethod = getPingAsyncSyncMethod =
              io.grpc.MethodDescriptor.<org.apache.camel.quarkus.component.grpc.it.model.PingRequest, org.apache.camel.quarkus.component.grpc.it.model.PongResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.CLIENT_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "PingAsyncSync"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.camel.quarkus.component.grpc.it.model.PingRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.camel.quarkus.component.grpc.it.model.PongResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PingPongMethodDescriptorSupplier("PingAsyncSync"))
              .build();
        }
      }
    }
    return getPingAsyncSyncMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.camel.quarkus.component.grpc.it.model.PingRequest,
      org.apache.camel.quarkus.component.grpc.it.model.PongResponse> getPingAsyncAsyncMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PingAsyncAsync",
      requestType = org.apache.camel.quarkus.component.grpc.it.model.PingRequest.class,
      responseType = org.apache.camel.quarkus.component.grpc.it.model.PongResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
  public static io.grpc.MethodDescriptor<org.apache.camel.quarkus.component.grpc.it.model.PingRequest,
      org.apache.camel.quarkus.component.grpc.it.model.PongResponse> getPingAsyncAsyncMethod() {
    io.grpc.MethodDescriptor<org.apache.camel.quarkus.component.grpc.it.model.PingRequest, org.apache.camel.quarkus.component.grpc.it.model.PongResponse> getPingAsyncAsyncMethod;
    if ((getPingAsyncAsyncMethod = PingPongGrpc.getPingAsyncAsyncMethod) == null) {
      synchronized (PingPongGrpc.class) {
        if ((getPingAsyncAsyncMethod = PingPongGrpc.getPingAsyncAsyncMethod) == null) {
          PingPongGrpc.getPingAsyncAsyncMethod = getPingAsyncAsyncMethod =
              io.grpc.MethodDescriptor.<org.apache.camel.quarkus.component.grpc.it.model.PingRequest, org.apache.camel.quarkus.component.grpc.it.model.PongResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "PingAsyncAsync"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.camel.quarkus.component.grpc.it.model.PingRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.camel.quarkus.component.grpc.it.model.PongResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PingPongMethodDescriptorSupplier("PingAsyncAsync"))
              .build();
        }
      }
    }
    return getPingAsyncAsyncMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static PingPongStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PingPongStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PingPongStub>() {
        @java.lang.Override
        public PingPongStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PingPongStub(channel, callOptions);
        }
      };
    return PingPongStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static PingPongBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PingPongBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PingPongBlockingStub>() {
        @java.lang.Override
        public PingPongBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PingPongBlockingStub(channel, callOptions);
        }
      };
    return PingPongBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static PingPongFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PingPongFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PingPongFutureStub>() {
        @java.lang.Override
        public PingPongFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PingPongFutureStub(channel, callOptions);
        }
      };
    return PingPongFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * The PingPong service definition.
   * </pre>
   */
  public static abstract class PingPongImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Sending ping message and getting pong answer synchronously
     * </pre>
     */
    public void pingSyncSync(org.apache.camel.quarkus.component.grpc.it.model.PingRequest request,
        io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PongResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getPingSyncSyncMethod(), responseObserver);
    }

    /**
     * <pre>
     * Sending ping message synchronously and getting pong answer asynchronously in streaming mode (multiple response messages)
     * </pre>
     */
    public void pingSyncAsync(org.apache.camel.quarkus.component.grpc.it.model.PingRequest request,
        io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PongResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getPingSyncAsyncMethod(), responseObserver);
    }

    /**
     * <pre>
     * Sending ping message asynchronously and getting pong answer synchronously
     * </pre>
     */
    public io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PingRequest> pingAsyncSync(
        io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PongResponse> responseObserver) {
      return asyncUnimplementedStreamingCall(getPingAsyncSyncMethod(), responseObserver);
    }

    /**
     * <pre>
     * Sending ping message asynchronously and getting pong answer asynchronously in streaming mode (multiple response messages)
     * </pre>
     */
    public io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PingRequest> pingAsyncAsync(
        io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PongResponse> responseObserver) {
      return asyncUnimplementedStreamingCall(getPingAsyncAsyncMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getPingSyncSyncMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                org.apache.camel.quarkus.component.grpc.it.model.PingRequest,
                org.apache.camel.quarkus.component.grpc.it.model.PongResponse>(
                  this, METHODID_PING_SYNC_SYNC)))
          .addMethod(
            getPingSyncAsyncMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                org.apache.camel.quarkus.component.grpc.it.model.PingRequest,
                org.apache.camel.quarkus.component.grpc.it.model.PongResponse>(
                  this, METHODID_PING_SYNC_ASYNC)))
          .addMethod(
            getPingAsyncSyncMethod(),
            asyncClientStreamingCall(
              new MethodHandlers<
                org.apache.camel.quarkus.component.grpc.it.model.PingRequest,
                org.apache.camel.quarkus.component.grpc.it.model.PongResponse>(
                  this, METHODID_PING_ASYNC_SYNC)))
          .addMethod(
            getPingAsyncAsyncMethod(),
            asyncBidiStreamingCall(
              new MethodHandlers<
                org.apache.camel.quarkus.component.grpc.it.model.PingRequest,
                org.apache.camel.quarkus.component.grpc.it.model.PongResponse>(
                  this, METHODID_PING_ASYNC_ASYNC)))
          .build();
    }
  }

  /**
   * <pre>
   * The PingPong service definition.
   * </pre>
   */
  public static final class PingPongStub extends io.grpc.stub.AbstractAsyncStub<PingPongStub> {
    private PingPongStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PingPongStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PingPongStub(channel, callOptions);
    }

    /**
     * <pre>
     * Sending ping message and getting pong answer synchronously
     * </pre>
     */
    public void pingSyncSync(org.apache.camel.quarkus.component.grpc.it.model.PingRequest request,
        io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PongResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getPingSyncSyncMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Sending ping message synchronously and getting pong answer asynchronously in streaming mode (multiple response messages)
     * </pre>
     */
    public void pingSyncAsync(org.apache.camel.quarkus.component.grpc.it.model.PingRequest request,
        io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PongResponse> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getPingSyncAsyncMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Sending ping message asynchronously and getting pong answer synchronously
     * </pre>
     */
    public io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PingRequest> pingAsyncSync(
        io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PongResponse> responseObserver) {
      return asyncClientStreamingCall(
          getChannel().newCall(getPingAsyncSyncMethod(), getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     * Sending ping message asynchronously and getting pong answer asynchronously in streaming mode (multiple response messages)
     * </pre>
     */
    public io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PingRequest> pingAsyncAsync(
        io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PongResponse> responseObserver) {
      return asyncBidiStreamingCall(
          getChannel().newCall(getPingAsyncAsyncMethod(), getCallOptions()), responseObserver);
    }
  }

  /**
   * <pre>
   * The PingPong service definition.
   * </pre>
   */
  public static final class PingPongBlockingStub extends io.grpc.stub.AbstractBlockingStub<PingPongBlockingStub> {
    private PingPongBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PingPongBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PingPongBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Sending ping message and getting pong answer synchronously
     * </pre>
     */
    public org.apache.camel.quarkus.component.grpc.it.model.PongResponse pingSyncSync(org.apache.camel.quarkus.component.grpc.it.model.PingRequest request) {
      return blockingUnaryCall(
          getChannel(), getPingSyncSyncMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Sending ping message synchronously and getting pong answer asynchronously in streaming mode (multiple response messages)
     * </pre>
     */
    public java.util.Iterator<org.apache.camel.quarkus.component.grpc.it.model.PongResponse> pingSyncAsync(
        org.apache.camel.quarkus.component.grpc.it.model.PingRequest request) {
      return blockingServerStreamingCall(
          getChannel(), getPingSyncAsyncMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * The PingPong service definition.
   * </pre>
   */
  public static final class PingPongFutureStub extends io.grpc.stub.AbstractFutureStub<PingPongFutureStub> {
    private PingPongFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PingPongFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PingPongFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Sending ping message and getting pong answer synchronously
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.apache.camel.quarkus.component.grpc.it.model.PongResponse> pingSyncSync(
        org.apache.camel.quarkus.component.grpc.it.model.PingRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getPingSyncSyncMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_PING_SYNC_SYNC = 0;
  private static final int METHODID_PING_SYNC_ASYNC = 1;
  private static final int METHODID_PING_ASYNC_SYNC = 2;
  private static final int METHODID_PING_ASYNC_ASYNC = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final PingPongImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(PingPongImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PING_SYNC_SYNC:
          serviceImpl.pingSyncSync((org.apache.camel.quarkus.component.grpc.it.model.PingRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PongResponse>) responseObserver);
          break;
        case METHODID_PING_SYNC_ASYNC:
          serviceImpl.pingSyncAsync((org.apache.camel.quarkus.component.grpc.it.model.PingRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PongResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PING_ASYNC_SYNC:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.pingAsyncSync(
              (io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PongResponse>) responseObserver);
        case METHODID_PING_ASYNC_ASYNC:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.pingAsyncAsync(
              (io.grpc.stub.StreamObserver<org.apache.camel.quarkus.component.grpc.it.model.PongResponse>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class PingPongBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    PingPongBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return org.apache.camel.quarkus.component.grpc.it.model.PingPongProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("PingPong");
    }
  }

  private static final class PingPongFileDescriptorSupplier
      extends PingPongBaseDescriptorSupplier {
    PingPongFileDescriptorSupplier() {}
  }

  private static final class PingPongMethodDescriptorSupplier
      extends PingPongBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    PingPongMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (PingPongGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new PingPongFileDescriptorSupplier())
              .addMethod(getPingSyncSyncMethod())
              .addMethod(getPingSyncAsyncMethod())
              .addMethod(getPingAsyncSyncMethod())
              .addMethod(getPingAsyncAsyncMethod())
              .build();
        }
      }
    }
    return result;
  }
}
