/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.grpc.it;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.grpc.it.GrpcServerTestResource;
import org.apache.camel.quarkus.component.grpc.it.model.PingPongGrpc;
import org.apache.camel.quarkus.component.grpc.it.model.PingRequest;
import org.apache.camel.quarkus.component.grpc.it.model.PongResponse;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=GrpcServerTestResource.class)
class GrpcTest {
    @ConfigProperty(name="camel.grpc.consumer.port")
    int consumerPort;

    GrpcTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void consumer() {
        ManagedChannel syncRequestChannel = null;
        try {
            syncRequestChannel = ManagedChannelBuilder.forAddress((String)"localhost", (int)this.consumerPort).usePlaintext().build();
            PingPongGrpc.PingPongBlockingStub blockingStub = PingPongGrpc.newBlockingStub((Channel)syncRequestChannel);
            PingRequest pingRequest = PingRequest.newBuilder().setPingName("foo").setPingId(567).build();
            PongResponse pongResponse = blockingStub.pingSyncSync(pingRequest);
            Assertions.assertNotNull((Object)pongResponse);
            Assertions.assertEquals((int)567, (int)pongResponse.getPongId());
            Assertions.assertEquals((Object)"foo PONG", (Object)pongResponse.getPongName());
        }
        finally {
            if (syncRequestChannel != null) {
                syncRequestChannel.shutdownNow();
            }
        }
    }

    @Test
    public void producer() {
        int id = 1234;
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType("text/plain").queryParam("pingId", new Object[]{id}).body("PING").post("/grpc/producer", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"PINGPONG"), new Matcher[0]);
    }
}

