/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.grpc.deployment;

import io.grpc.BindableService;
import io.grpc.stub.AbstractAsyncStub;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.AbstractFutureStub;
import io.grpc.stub.StreamObserver;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.grpc.GrpcService;
import io.quarkus.grpc.deployment.BindableServiceBuildItem;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.component.grpc.GrpcComponent;
import org.apache.camel.component.grpc.server.GrpcMethodHandler;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;
import org.apache.camel.quarkus.grpc.runtime.CamelGrpcRecorder;
import org.apache.camel.quarkus.grpc.runtime.CamelQuarkusBindableService;
import org.apache.camel.quarkus.grpc.runtime.QuarkusBindableServiceFactory;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class GrpcProcessor {
    private static final DotName BINDABLE_SERVICE_DOT_NAME = DotName.createSimple((String)BindableService.class.getName());
    private static final DotName[] STUB_CLASS_DOT_NAMES = new DotName[]{DotName.createSimple((String)AbstractAsyncStub.class.getName()), DotName.createSimple((String)AbstractBlockingStub.class.getName()), DotName.createSimple((String)AbstractFutureStub.class.getName())};
    private static final String FEATURE = "camel-grpc";

    GrpcProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndexBuildItem) {
        IndexView index = combinedIndexBuildItem.getIndex();
        for (DotName dotName : STUB_CLASS_DOT_NAMES) {
            index.getAllKnownSubclasses(dotName).stream().map(classInfo -> new ReflectiveClassBuildItem(true, false, new String[]{classInfo.name().toString()})).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        }
    }

    @BuildStep
    void createBindableServiceBeans(BuildProducer<GeneratedBeanBuildItem> generatedBean, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<BindableServiceBuildItem> bindableService, CombinedIndexBuildItem combinedIndexBuildItem) {
        Set<String> services = this.generateBindableServiceBeans(generatedBean, reflectiveClass, combinedIndexBuildItem.getIndex());
        services.stream().map(DotName::createSimple).map(BindableServiceBuildItem::new).forEach(arg_0 -> bindableService.produce(arg_0));
    }

    @BuildStep
    void quarkusBindableServiceFactoryBean(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(QuarkusBindableServiceFactory.class));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    CamelBeanBuildItem createGrpcComponent(CamelGrpcRecorder recorder) {
        return new CamelBeanBuildItem("grpc", GrpcComponent.class.getName(), recorder.createGrpcComponent());
    }

    private Set<String> generateBindableServiceBeans(BuildProducer<GeneratedBeanBuildItem> generatedBean, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, IndexView index) {
        HashSet<String> generatedBindableServiceClassNames = new HashSet<String>();
        Collection bindableServiceImpls = index.getAllKnownImplementors(BINDABLE_SERVICE_DOT_NAME);
        for (ClassInfo service : bindableServiceImpls) {
            if (!Modifier.isAbstract(service.flags()) || service.name().withoutPackagePrefix().startsWith("Mutiny")) continue;
            String superClassName = service.name().toString();
            String generatedClassName = superClassName + "QuarkusMethodHandler";
            generatedBindableServiceClassNames.add(generatedClassName);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{service.name().toString()}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{service.enclosingClass().toString()}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{generatedClassName}));
            ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBean)).className(generatedClassName).superClass(superClassName).interfaces(new Class[]{CamelQuarkusBindableService.class}).build();
            try {
                classCreator.addAnnotation(GrpcService.class);
                FieldCreator serverMethodHandler = (FieldCreator)classCreator.getFieldCreator("methodHandler", GrpcMethodHandler.class.getName()).setModifiers(2);
                try (MethodCreator initMethod = classCreator.getMethodCreator("<init>", Void.TYPE, new Class[0]);){
                    initMethod.setModifiers(1);
                    initMethod.invokeSpecialMethod(MethodDescriptor.ofMethod((Object)superClassName, (String)"<init>", Void.TYPE, (Object[])new Object[0]), initMethod.getThis(), new ResultHandle[0]);
                    initMethod.returnValue(null);
                }
                try (MethodCreator setMethodHandlerMethod = classCreator.getMethodCreator("setMethodHandler", Void.TYPE, new Class[]{GrpcMethodHandler.class});){
                    setMethodHandlerMethod.setModifiers(1);
                    ResultHandle self = setMethodHandlerMethod.getThis();
                    ResultHandle methodHandlerInstance = setMethodHandlerMethod.getMethodParam(0);
                    setMethodHandlerMethod.writeInstanceField(serverMethodHandler.getFieldDescriptor(), self, methodHandlerInstance);
                    setMethodHandlerMethod.returnValue(null);
                }
                List methods = service.methods();
                for (MethodInfo method : methods) {
                    if (!this.isCandidateServiceMethod(method)) continue;
                    String[] params = (String[])method.parameters().stream().map(type -> type.name().toString()).toArray(String[]::new);
                    ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)GrpcMethodHandler.class.getName()));
                    String returnType = method.returnType().name().toString();
                    MethodCreator methodCreator = classCreator.getMethodCreator(method.name(), returnType, params);
                    try {
                        method.exceptions().stream().map(type -> type.name().toString()).forEach(arg_0 -> ((MethodCreator)methodCreator).addException(arg_0));
                        if (method.parameters().size() == 1) {
                            ResultHandle returnValue = this.generateGrpcDelegateMethod(classInfo, serverMethodHandler, methodCreator, method, "handleForConsumerStrategy");
                            methodCreator.returnValue(returnValue);
                            continue;
                        }
                        if (method.parameters().size() != 2) continue;
                        this.generateGrpcDelegateMethod(classInfo, serverMethodHandler, methodCreator, method, "handle");
                        methodCreator.returnValue(null);
                    }
                    finally {
                        if (methodCreator == null) continue;
                        methodCreator.close();
                    }
                }
            }
            finally {
                if (classCreator == null) continue;
                classCreator.close();
            }
        }
        return generatedBindableServiceClassNames;
    }

    private boolean isCandidateServiceMethod(MethodInfo method) {
        List parameters = method.parameters();
        if (parameters.size() == 1) {
            return ((Type)parameters.get(0)).name().toString().equals(StreamObserver.class.getName());
        }
        if (parameters.size() == 2) {
            return ((Type)parameters.get(1)).name().toString().equals(StreamObserver.class.getName());
        }
        return false;
    }

    private ResultHandle generateGrpcDelegateMethod(ClassInfo classInfo, FieldCreator fieldCreator, MethodCreator methodCreator, MethodInfo sourceMethod, String targetMethod) {
        MethodInfo method = classInfo.methods().stream().filter(methodInfo -> methodInfo.name().equals(targetMethod)).findFirst().orElseThrow(() -> new RuntimeException("Unable to find target method " + targetMethod + " on GrpcServerMethodHandler"));
        ResultHandle methodNameParam = methodCreator.load(sourceMethod.name());
        ResultHandle[] methodParams = sourceMethod.parameters().size() == 1 ? new ResultHandle[]{methodCreator.getMethodParam(0), methodNameParam} : new ResultHandle[]{methodCreator.getMethodParam(0), methodCreator.getMethodParam(1), methodNameParam};
        ResultHandle resultHandle = methodCreator.readInstanceField(fieldCreator.getFieldDescriptor(), methodCreator.getThis());
        return methodCreator.invokeVirtualMethod(method, resultHandle, methodParams);
    }
}

