/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.grpc.codegen;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.ModifierVisitor;
import com.github.javaparser.ast.visitor.Visitable;
import com.github.javaparser.utils.SourceRoot;
import java.io.File;
import java.nio.file.Path;
import org.jboss.logging.Logger;

public class CamelQuarkusGrpcPostProcessor {
    private static final Logger LOG = Logger.getLogger(CamelQuarkusGrpcPostProcessor.class);
    private static final String JAVAX_GENERATED = "javax.annotation.Generated";
    private static final String JAKARTA_GENERATED = "jakarta.annotation.Generated";
    private final Path root;

    public CamelQuarkusGrpcPostProcessor(Path root) {
        this.root = root;
    }

    public static void main(String[] args) {
        for (String arg : args) {
            Path path = new File(arg).toPath();
            CamelQuarkusGrpcPostProcessor postProcessor = new CamelQuarkusGrpcPostProcessor(path);
            postProcessor.process();
        }
    }

    public void process() {
        SourceRoot sr = new SourceRoot(this.root);
        try {
            sr.parse("", (localPath, absolutePath, result) -> {
                if (result.isSuccessful()) {
                    CompilationUnit unit = (CompilationUnit)result.getResult().orElseThrow();
                    if (unit.getPrimaryType().isPresent()) {
                        TypeDeclaration type = (TypeDeclaration)unit.getPrimaryType().get();
                        this.process(unit, type);
                        return SourceRoot.Callback.Result.SAVE;
                    }
                } else {
                    LOG.errorf("Unable to parse a protoc generated class, skipping post-processing for this file. Reported problems are %s", (Object)result.toString());
                }
                return SourceRoot.Callback.Result.DONT_SAVE;
            });
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to parse protoc generated classes - skipping gRPC post processing", (Throwable)e);
        }
    }

    private void process(CompilationUnit unit, TypeDeclaration<?> primary) {
        LOG.debugf("Post-processing %s", (Object)primary.getFullyQualifiedName().orElse(primary.getNameAsString()));
        unit.accept((GenericVisitor)new ModifierVisitor<Void>(){

            public Visitable visit(NormalAnnotationExpr n, Void arg) {
                if (n.getNameAsString().equals(CamelQuarkusGrpcPostProcessor.JAVAX_GENERATED)) {
                    n.setName(CamelQuarkusGrpcPostProcessor.JAKARTA_GENERATED);
                }
                return super.visit(n, (Object)arg);
            }
        }, null);
    }
}

