/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.dsl.groovy.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.quarkus.core.deployment.main.CamelMainHelper;
import org.apache.camel.quarkus.dsl.groovy.runtime.Configurer;
import org.apache.camel.quarkus.support.dsl.deployment.DslGeneratedClassBuildItem;
import org.apache.camel.quarkus.support.dsl.deployment.DslSupportProcessor;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.IOHelper;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.tools.GroovyClass;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyDslProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(GroovyDslProcessor.class);
    private static final List<Class<?>> CAMEL_REFLECTIVE_CLASSES = Arrays.asList(Exchange.class, Message.class, ExchangePattern.class, CamelContext.class);
    private static final String PACKAGE_NAME = "org.apache.camel.quarkus.dsl.groovy.generated";
    private static final String FILE_FORMAT = "package %s\n%s\n@groovy.transform.InheritConstructors\nclass %s extends %s {\n  void configure() {\n    %s\n  }\n}\n";
    private static final String FEATURE = "camel-groovy-dsl";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void compileScriptsAOT(BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<DslGeneratedClassBuildItem> generatedGroovyClass, CurateOutcomeBuildItem curateOutcomeBuildItem) throws Exception {
        LOG.debug("Loading .groovy resources");
        HashMap nameToResource = new HashMap();
        CompilationUnit unit = new CompilationUnit();
        CamelMainHelper.forEachMatchingResource(resource -> {
            if (!resource.getLocation().endsWith(".groovy")) {
                return;
            }
            try (InputStream is = resource.getInputStream();){
                String name = DslSupportProcessor.determineName((Resource)resource);
                String fqn = String.format("%s.%s", PACKAGE_NAME, name);
                unit.addSource(fqn, GroovyDslProcessor.toGroovyClass(name, IOHelper.loadText((InputStream)is)));
                nameToResource.put(fqn, resource);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (nameToResource.isEmpty()) {
            return;
        }
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.setClasspathList(curateOutcomeBuildItem.getApplicationModel().getDependencies().stream().map(ResolvedDependency::getResolvedPaths).flatMap(PathCollection::stream).map(Objects::toString).toList());
        unit.configure(cc);
        unit.compile(7);
        for (GroovyClass clazz : unit.getClasses()) {
            String className = clazz.getName();
            generatedClass.produce((BuildItem)new GeneratedClassBuildItem(true, className, clazz.getBytes()));
            if (!nameToResource.containsKey(className)) continue;
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className}).build());
            generatedGroovyClass.produce((BuildItem)new DslGeneratedClassBuildItem(className, ((Resource)nameToResource.get(className)).getLocation()));
        }
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void registerReflectiveClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndexBuildItem) {
        IndexView view = combinedIndexBuildItem.getIndex();
        for (Class<?> type : CAMEL_REFLECTIVE_CLASSES) {
            DotName name = DotName.createSimple((String)type.getName());
            if (type.isInterface()) {
                for (ClassInfo info : view.getAllKnownImplementors(name)) {
                    reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{info.name().toString()}).methods().build());
                }
            } else {
                for (ClassInfo info : view.getAllKnownSubclasses(name)) {
                    reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{info.name().toString()}).methods().build());
                }
            }
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{type}).methods().fields(type.isEnum()).build());
        }
        HashSet types = new HashSet();
        for (Class<?> c : CAMEL_REFLECTIVE_CLASSES) {
            for (Method method : c.getMethods()) {
                Class<?> returnType;
                if (method.getDeclaringClass().equals(Object.class) || !(returnType = method.getReturnType()).getPackageName().startsWith("org.apache.camel.") || CAMEL_REFLECTIVE_CLASSES.contains(returnType)) continue;
                types.add(returnType);
            }
        }
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])types.toArray(new Class[0])).constructors(false).methods().build());
    }

    private static String toGroovyClass(String name, String contentResource) {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("import org.apache.camel.*");
        imports.add("import org.apache.camel.spi.*");
        DslSupportProcessor.ExtractImportResult extractImportResult = DslSupportProcessor.extractImports((String)contentResource);
        imports.addAll(extractImportResult.getImports());
        return String.format(FILE_FORMAT, PACKAGE_NAME, String.join((CharSequence)"\n", imports), name, Configurer.class.getName(), extractImportResult.getContent());
    }
}

