/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.google.drive.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.Collection;
import org.apache.camel.quarkus.core.deployment.spi.UnbannedReflectiveBuildItem;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class GoogleDriveProcessor {
    private static final String FEATURE = "camel-google-drive";

    GoogleDriveProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void applicationArchiveMarkers(BuildProducer<AdditionalApplicationArchiveMarkerBuildItem> applicationArchiveMarker) {
        applicationArchiveMarker.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem("com/google/api/services/drive"));
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<UnbannedReflectiveBuildItem> unbannedClass, CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        Collection uriParams = index.getAnnotations(DotName.createSimple((String)"org.apache.camel.spi.UriParams"));
        String[] googleDriveConfigClasses = (String[])uriParams.stream().map(annotation -> annotation.target()).filter(annotationTarget -> annotationTarget.kind().equals((Object)AnnotationTarget.Kind.CLASS)).map(annotationTarget -> annotationTarget.asClass().name().toString()).filter(className -> className.startsWith("org.apache.camel.component.google.drive")).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, googleDriveConfigClasses));
        unbannedClass.produce((BuildItem)new UnbannedReflectiveBuildItem(googleDriveConfigClasses));
    }
}

