/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.github.deployment;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.io.Serializable;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class GithubProcessor {
    private static final String FEATURE = "camel-github";

    GithubProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem egitArchiveMarker() {
        return new AdditionalApplicationArchiveMarkerBuildItem("org/eclipse/egit/github");
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        index.getKnownDirectImplementors(DotName.createSimple((String)Serializable.class.getName())).stream().filter(classInfo -> classInfo.name().prefix().toString().equals("org.eclipse.egit.github.core")).map(className -> ReflectiveClassBuildItem.builder((String[])new String[]{className.name().toString()}).methods(false).fields(true).build()).forEach(arg_0 -> reflectiveClass.produce(arg_0));
    }
}

