/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fop.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.render.RendererEventProducer;
import org.apache.fop.render.pdf.PDFDocumentHandlerMaker;
import org.apache.fop.render.pdf.extensions.PDFExtensionHandlerFactory;
import org.apache.fop.util.ColorUtil;
import org.apache.xmlgraphics.image.loader.spi.ImageImplRegistry;
import org.apache.xmlgraphics.java2d.color.ICCColorSpaceWithIntent;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class FopProcessor {
    private static final String FEATURE = "camel-fop";

    FopProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ReflectiveClassBuildItem registerForReflection(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        List<String> dtos = index.getKnownClasses().stream().map(ci -> ci.name().toString()).filter(n -> n.endsWith("ElementMapping")).sorted().collect(Collectors.toList());
        dtos.add(PDFExtensionHandlerFactory.class.getName());
        dtos.add(PDFDocumentHandlerMaker.class.getName());
        dtos.add(RendererEventProducer.class.getName());
        dtos.add(IOException.class.getName());
        dtos.add(Integer.class.getName());
        return ReflectiveClassBuildItem.builder((String[])dtos.toArray(new String[dtos.size()])).build();
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.apache.xmlgraphics", "fop"));
    }

    @BuildStep
    NativeImageResourceBuildItem initResources() {
        return new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.apache.fop.fo.ElementMapping", "META-INF/services/org.apache.fop.render.intermediate.IFDocumentHandler", "org/apache/fop/render/event-model.xml"});
    }

    @BuildStep
    NativeImageProxyDefinitionBuildItem initProxies() {
        return new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.fop.render.RendererEventProducer"});
    }

    @BuildStep
    public void registerRuntimeInitializedClasses(CombinedIndexBuildItem combinedIndex, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClass) {
        combinedIndex.getIndex().getAllKnownSubclasses(DotName.createSimple((String)Base14Font.class.getName())).stream().map(classInfo -> classInfo.name().toString()).map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> runtimeInitializedClass.produce(arg_0));
        runtimeInitializedClass.produce((BuildItem)new RuntimeInitializedClassBuildItem(ImageImplRegistry.class.getName()));
        runtimeInitializedClass.produce((BuildItem)new RuntimeInitializedClassBuildItem(ColorUtil.class.getName()));
        runtimeInitializedClass.produce((BuildItem)new RuntimeInitializedClassBuildItem(ICCColorSpaceWithIntent.class.getName()));
    }
}

