/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.file.cluster;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.concurrent.TimeUnit;
import org.apache.camel.catalog.impl.TimePatternConverter;
import org.apache.camel.component.file.cluster.FileLockClusterService;
import org.apache.camel.quarkus.component.file.cluster.FileLockClusterServiceConfig;

@Recorder
public class FileLockClusterServiceRecorder {
    public RuntimeValue<FileLockClusterService> createFileLockClusterService(FileLockClusterServiceConfig config) {
        FileLockClusterService flcs = new FileLockClusterService();
        config.id.ifPresent(id -> flcs.setId(id));
        config.root.ifPresent(root -> flcs.setRoot(root));
        config.order.ifPresent(order -> flcs.setOrder(order.intValue()));
        config.acquireLockDelay.ifPresent(delay -> flcs.setAcquireLockDelay(TimePatternConverter.toMilliSeconds((String)delay), TimeUnit.MILLISECONDS));
        config.acquireLockInterval.ifPresent(interval -> flcs.setAcquireLockInterval(TimePatternConverter.toMilliSeconds((String)interval), TimeUnit.MILLISECONDS));
        config.attributes.forEach((key, value) -> flcs.setAttribute(key, value));
        return new RuntimeValue((Object)flcs);
    }
}

