/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.deployment.r5;

import ca.uhn.fhir.context.FhirContext;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import jakarta.inject.Singleton;
import java.util.HashSet;
import org.apache.camel.quarkus.component.fhir.FhirContextRecorder;
import org.apache.camel.quarkus.component.fhir.FhirFlags;
import org.apache.camel.quarkus.component.fhir.deployment.FhirUtil;
import org.apache.camel.quarkus.component.fhir.deployment.r5.R5PropertiesBuildItem;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BaseResource;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Resource;

public class FhirR5Processor {
    private static final String FHIR_VERSION_PROPERTIES = "org/hl7/fhir/r5/model/fhirversion.properties";

    @BuildStep(onlyIf={FhirFlags.R5Enabled.class})
    R5PropertiesBuildItem fhirProperties() {
        return new R5PropertiesBuildItem(FHIR_VERSION_PROPERTIES);
    }

    @BuildStep(onlyIf={FhirFlags.R5Enabled.class})
    NativeImageResourceBuildItem nativeImageResources() {
        return new NativeImageResourceBuildItem(new String[]{FHIR_VERSION_PROPERTIES});
    }

    @BuildStep(onlyIf={FhirFlags.R5Enabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    SyntheticBeanBuildItem recordFhirContext(FhirContextRecorder recorder, R5PropertiesBuildItem propertiesBuildItem) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(FhirContext.class).scope(Singleton.class)).named("R5")).runtimeValue(recorder.createR5FhirContext(FhirUtil.getResourceDefinitions(propertiesBuildItem.getProperties()))).done();
    }

    @BuildStep(onlyIf={FhirFlags.R5Enabled.class})
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, R5PropertiesBuildItem propertiesBuildItem) {
        HashSet<String> classes = new HashSet<String>();
        classes.add(DomainResource.class.getName());
        classes.add(Resource.class.getName());
        classes.add(BaseResource.class.getName());
        classes.add(Base.class.getName());
        classes.addAll(FhirUtil.getModelClasses(propertiesBuildItem.getProperties()));
        classes.addAll(FhirUtil.getInnerClasses(Enumerations.class.getName()));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{Meta.class.getName()}).methods().fields().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{MetadataResource.class.getName()}).methods().fields().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classes.toArray(new String[0])).build());
    }
}

