/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.deployment.dstu2Hl7Org;

import ca.uhn.fhir.context.FhirContext;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import jakarta.inject.Singleton;
import java.util.HashSet;
import org.apache.camel.quarkus.component.fhir.FhirContextRecorder;
import org.apache.camel.quarkus.component.fhir.FhirFlags;
import org.apache.camel.quarkus.component.fhir.deployment.FhirUtil;
import org.apache.camel.quarkus.component.fhir.deployment.dstu2Hl7Org.Dstu2Hl7OrgPropertiesBuildItem;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BaseResource;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.Meta;
import org.hl7.fhir.dstu2.model.Resource;

public class FhirDstu2Hl7OrgProcessor {
    private static final String FHIR_VERSION_PROPERTIES = "org/hl7/fhir/instance/model/fhirversion.properties";

    @BuildStep(onlyIf={FhirFlags.Dstu2Hl7OrgEnabled.class})
    Dstu2Hl7OrgPropertiesBuildItem fhirProperties() {
        return new Dstu2Hl7OrgPropertiesBuildItem(FHIR_VERSION_PROPERTIES);
    }

    @BuildStep(onlyIf={FhirFlags.Dstu2Hl7OrgEnabled.class})
    NativeImageResourceBuildItem nativeImageResources() {
        return new NativeImageResourceBuildItem(new String[]{FHIR_VERSION_PROPERTIES});
    }

    @BuildStep(onlyIf={FhirFlags.Dstu2Hl7OrgEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    SyntheticBeanBuildItem recordFhirContext(FhirContextRecorder recorder, Dstu2Hl7OrgPropertiesBuildItem propertiesBuildItem) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(FhirContext.class).scope(Singleton.class)).named("DSTU2_HL7ORG")).runtimeValue(recorder.createDstu2Hl7OrgFhirContext(FhirUtil.getResourceDefinitions(propertiesBuildItem.getProperties()))).done();
    }

    @BuildStep(onlyIf={FhirFlags.Dstu2Hl7OrgEnabled.class})
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Dstu2Hl7OrgPropertiesBuildItem propertiesBuildItem) {
        HashSet<String> classes = new HashSet<String>();
        classes.add(DomainResource.class.getName());
        classes.add(Resource.class.getName());
        classes.add(BaseResource.class.getName());
        classes.add(Base.class.getName());
        classes.addAll(FhirUtil.getModelClasses(propertiesBuildItem.getProperties()));
        classes.addAll(FhirUtil.getInnerClasses(Enumerations.class.getName()));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{Meta.class.getName()}).methods().fields().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classes.toArray(new String[0])).build());
    }
}

