/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.deployment.dstu2;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import jakarta.inject.Singleton;
import java.util.HashSet;
import org.apache.camel.quarkus.component.fhir.FhirContextRecorder;
import org.apache.camel.quarkus.component.fhir.FhirFlags;
import org.apache.camel.quarkus.component.fhir.deployment.FhirUtil;
import org.apache.camel.quarkus.component.fhir.deployment.dstu2.Dstu2PropertiesBuildItem;

public class FhirDstu2Processor {
    private static final String FHIR_VERSION_PROPERTIES = "ca/uhn/fhir/model/dstu2/fhirversion.properties";

    @BuildStep(onlyIf={FhirFlags.Dstu2Enabled.class})
    Dstu2PropertiesBuildItem fhirProperties() {
        return new Dstu2PropertiesBuildItem(FHIR_VERSION_PROPERTIES);
    }

    @BuildStep(onlyIf={FhirFlags.Dstu2Enabled.class})
    NativeImageResourceBuildItem nativeImageResources() {
        return new NativeImageResourceBuildItem(new String[]{FHIR_VERSION_PROPERTIES});
    }

    @BuildStep(onlyIf={FhirFlags.Dstu2Enabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    SyntheticBeanBuildItem recordFhirContext(FhirContextRecorder recorder, Dstu2PropertiesBuildItem propertiesBuildItem) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(FhirContext.class).scope(Singleton.class)).named("DSTU2")).runtimeValue(recorder.createDstu2FhirContext(FhirUtil.getResourceDefinitions(propertiesBuildItem.getProperties()))).done();
    }

    @BuildStep(onlyIf={FhirFlags.Dstu2Enabled.class})
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Dstu2PropertiesBuildItem propertiesBuildItem, CombinedIndexBuildItem combinedIndex) {
        HashSet<String> classes = new HashSet<String>();
        classes.add(BaseResource.class.getCanonicalName());
        classes.addAll(FhirUtil.getModelClasses(propertiesBuildItem.getProperties()));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classes.toArray(new String[0])).build());
        String[] dstu2Enums = (String[])combinedIndex.getIndex().getKnownClasses().stream().map(classInfo -> classInfo.toString()).filter(className -> className.startsWith("ca.uhn.fhir.model.dstu2.valueset")).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])dstu2Enums).build());
    }
}

