/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.deployment;

import ca.uhn.fhir.rest.client.apache.ApacheRestfulClientFactory;
import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.util.jar.DependencyLogImpl;
import ca.uhn.fhir.validation.schematron.SchematronBaseValidator;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.MethodCreator;
import java.util.function.BooleanSupplier;
import org.apache.camel.quarkus.component.fhir.IsSchematronAbsent;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

final class FhirProcessor {
    private static final String FEATURE = "camel-fhir";
    private static final String RESTFUL_SERVER_UTILS_CLASS_NAME = "ca.uhn.fhir.rest.server.RestfulServerUtils";
    private static final String[] INTERCEPTOR_CLASSES = new String[]{IClientInterceptor.class.getName()};

    FhirProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    NativeImageResourceBundleBuildItem hapiMessages() {
        return new NativeImageResourceBundleBuildItem("ca.uhn.fhir.i18n.hapi-messages");
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem hl7ArchiveMarker() {
        return new AdditionalApplicationArchiveMarkerBuildItem("org/hl7/fhir");
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem hapiArchiveMarker() {
        return new AdditionalApplicationArchiveMarkerBuildItem("ca/uhn/fhir");
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        IndexView index = combinedIndex.getIndex();
        index.getAllKnownSubclasses(DotName.createSimple((String)BaseServerResponseException.class.getName())).stream().map(classInfo -> ReflectiveClassBuildItem.builder((String[])new String[]{classInfo.name().toString()}).build()).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        String[] clientInterceptors = (String[])index.getAllKnownImplementors(DotName.createSimple((String)IClientInterceptor.class.getName())).stream().map(classInfo -> classInfo.name().toString()).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])clientInterceptors).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])INTERCEPTOR_CLASSES).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{DependencyLogImpl.class}).fields().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ApacheRestfulClientFactory.class}).methods().fields().build());
    }

    @BuildStep(onlyIfNot={IsSchematronAbsent.class})
    void registerSchematronForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{SchematronBaseValidator.class}).fields().build());
    }

    @BuildStep(onlyIf={NativeBuild.class, IsFhirServerAbsent.class})
    void generateRestfulServerUtils(BuildProducer<GeneratedClassBuildItem> generatedClass) {
        try (ClassCreator classCreator = ClassCreator.builder().className(RESTFUL_SERVER_UTILS_CLASS_NAME).classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, false)).setFinal(true).superClass(Object.class.getName()).build();
             MethodCreator methodCreator = classCreator.getMethodCreator("createEtag", String.class, new Class[]{String.class});){
            methodCreator.setModifiers(9);
            Gizmo.StringBuilderGenerator stringBuilder = Gizmo.newStringBuilder((BytecodeCreator)methodCreator);
            stringBuilder.append("W/");
            stringBuilder.append('\"');
            stringBuilder.append(methodCreator.getMethodParam(0));
            stringBuilder.append('\"');
            methodCreator.returnValue(stringBuilder.callToString());
        }
    }

    static final class IsFhirServerAbsent
    implements BooleanSupplier {
        IsFhirServerAbsent() {
        }

        @Override
        public boolean getAsBoolean() {
            try {
                Class.forName(FhirProcessor.RESTFUL_SERVER_UTILS_CLASS_NAME);
                return false;
            }
            catch (ClassNotFoundException e) {
                return true;
            }
        }
    }
}

