/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.deployment.r5;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.HashSet;
import org.apache.camel.quarkus.component.fhir.FhirContextRecorder;
import org.apache.camel.quarkus.component.fhir.FhirFlags;
import org.apache.camel.quarkus.component.fhir.deployment.FhirUtil;
import org.apache.camel.quarkus.component.fhir.deployment.r5.R5PropertiesBuildItem;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BaseResource;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Resource;

public class FhirR5Processor {
    private static final String FHIR_VERSION_PROPERTIES = "org/hl7/fhir/r5/model/fhirversion.properties";

    @BuildStep(onlyIf={FhirFlags.R5Enabled.class})
    R5PropertiesBuildItem properties(BuildProducer<NativeImageResourceBuildItem> resource) {
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{FHIR_VERSION_PROPERTIES}));
        return new R5PropertiesBuildItem(FHIR_VERSION_PROPERTIES);
    }

    @BuildStep(onlyIf={FhirFlags.R5Enabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void recordContext(FhirContextRecorder fhirContextRecorder, BeanContainerBuildItem beanContainer, R5PropertiesBuildItem propertiesBuildItem) {
        fhirContextRecorder.createR5FhirContext(beanContainer.getValue(), FhirUtil.getResourceDefinitions(propertiesBuildItem.getProperties()));
    }

    @BuildStep(onlyIf={FhirFlags.R5Enabled.class})
    void enableReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, R5PropertiesBuildItem buildItem) {
        HashSet<String> classes = new HashSet<String>();
        classes.add(DomainResource.class.getCanonicalName());
        classes.add(Resource.class.getCanonicalName());
        classes.add(BaseResource.class.getCanonicalName());
        classes.add(Base.class.getCanonicalName());
        classes.addAll(FhirUtil.getModelClasses(buildItem.getProperties()));
        classes.addAll(FhirUtil.getInnerClasses(Enumerations.class.getCanonicalName()));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{Meta.class.getCanonicalName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{MetadataResource.class.getCanonicalName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, classes.toArray(new String[0])));
    }
}

