/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.deployment.r4;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.HashSet;
import org.apache.camel.quarkus.component.fhir.FhirContextRecorder;
import org.apache.camel.quarkus.component.fhir.FhirFlags;
import org.apache.camel.quarkus.component.fhir.deployment.FhirUtil;
import org.apache.camel.quarkus.component.fhir.deployment.r4.R4PropertiesBuildItem;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Resource;

public class FhirR4Processor {
    private static final String FHIR_VERSION_PROPERTIES = "org/hl7/fhir/r4/model/fhirversion.properties";

    @BuildStep(onlyIf={FhirFlags.R4Enabled.class})
    R4PropertiesBuildItem properties(BuildProducer<NativeImageResourceBuildItem> resource) {
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{FHIR_VERSION_PROPERTIES}));
        return new R4PropertiesBuildItem(FHIR_VERSION_PROPERTIES);
    }

    @BuildStep(onlyIf={FhirFlags.R4Enabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void recordContext(FhirContextRecorder fhirContextRecorder, BeanContainerBuildItem beanContainer, R4PropertiesBuildItem propertiesBuildItem) {
        fhirContextRecorder.createR4FhirContext(beanContainer.getValue(), FhirUtil.getResourceDefinitions(propertiesBuildItem.getProperties()));
    }

    @BuildStep(onlyIf={FhirFlags.R4Enabled.class})
    void enableReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, R4PropertiesBuildItem buildItem) {
        HashSet<String> classes = new HashSet<String>();
        classes.add(DomainResource.class.getCanonicalName());
        classes.add(Resource.class.getCanonicalName());
        classes.add(BaseResource.class.getCanonicalName());
        classes.add(Base.class.getCanonicalName());
        classes.addAll(FhirUtil.getModelClasses(buildItem.getProperties()));
        classes.addAll(FhirUtil.getInnerClasses(Enumerations.class.getCanonicalName()));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{Meta.class.getCanonicalName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{MetadataResource.class.getCanonicalName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, classes.toArray(new String[0])));
    }
}

