/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.deployment.dstu3;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.HashSet;
import org.apache.camel.quarkus.component.fhir.FhirContextRecorder;
import org.apache.camel.quarkus.component.fhir.FhirFlags;
import org.apache.camel.quarkus.component.fhir.deployment.FhirUtil;
import org.apache.camel.quarkus.component.fhir.deployment.dstu3.Dstu3PropertiesBuildItem;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BaseResource;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Meta;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.Resource;

public class FhirDstu3Processor {
    private static final String FHIR_VERSION_PROPERTIES = "org/hl7/fhir/dstu3/model/fhirversion.properties";

    @BuildStep(onlyIf={FhirFlags.Dstu3Enabled.class})
    Dstu3PropertiesBuildItem properties(BuildProducer<NativeImageResourceBuildItem> resource) {
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{FHIR_VERSION_PROPERTIES}));
        return new Dstu3PropertiesBuildItem(FHIR_VERSION_PROPERTIES);
    }

    @BuildStep(onlyIf={FhirFlags.Dstu3Enabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void recordContext(FhirContextRecorder fhirContextRecorder, BeanContainerBuildItem beanContainer, Dstu3PropertiesBuildItem propertiesBuildItem) {
        fhirContextRecorder.createDstu3FhirContext(beanContainer.getValue(), FhirUtil.getResourceDefinitions(propertiesBuildItem.getProperties()));
    }

    @BuildStep(onlyIf={FhirFlags.Dstu3Enabled.class})
    void enableReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Dstu3PropertiesBuildItem propertiesBuildItem) {
        HashSet<String> classes = new HashSet<String>();
        classes.add(DomainResource.class.getCanonicalName());
        classes.add(Resource.class.getCanonicalName());
        classes.add(BaseResource.class.getCanonicalName());
        classes.add(Base.class.getCanonicalName());
        classes.addAll(FhirUtil.getModelClasses(propertiesBuildItem.getProperties()));
        classes.addAll(FhirUtil.getInnerClasses(Enumerations.class.getCanonicalName()));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{Meta.class.getCanonicalName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{MetadataResource.class.getCanonicalName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, classes.toArray(new String[0])));
    }
}

