/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.fhir.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public final class FhirUtil {
    private static final String RESOURCE_PREFIX = "resource.";

    private FhirUtil() {
    }

    public static Collection<String> getModelClasses(Map<String, String> properties) {
        return FhirUtil.getInnerClasses(properties.values().toArray(new String[0]));
    }

    public static Collection<String> getResourceDefinitions(Map<String, String> properties) {
        ArrayList<String> resources = new ArrayList<String>();
        for (String stringPropertyName : properties.keySet()) {
            if (!stringPropertyName.contains(RESOURCE_PREFIX)) continue;
            resources.add(stringPropertyName.substring(RESOURCE_PREFIX.length()));
        }
        return resources;
    }

    public static Collection<String> getInnerClasses(String ... classList) {
        try {
            HashSet<String> classes = new HashSet<String>();
            String[] stringArray = classList;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?>[] parent;
                String value;
                String clazz = value = stringArray[i];
                for (Class<?> aClass : parent = Class.forName(clazz).getClasses()) {
                    String name = aClass.getName();
                    classes.add(name);
                }
                classes.add(clazz);
            }
            return classes;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Please ensure FHIR is on the classpath", e);
        }
    }
}

