/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.dozer.deployment;

import com.github.dozermapper.core.DozerBeanMapperBuilder;
import com.github.dozermapper.core.Mapper;
import com.sun.el.ExpressionFactoryImpl;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.jaxb.deployment.JaxbFileRootBuildItem;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.camel.converter.dozer.DozerBeanMapperConfiguration;
import org.apache.camel.converter.dozer.DozerThreadContextClassLoader;
import org.apache.camel.quarkus.component.dozer.CamelDozerConfig;
import org.apache.camel.quarkus.component.dozer.CamelDozerRecorder;
import org.apache.camel.quarkus.core.deployment.CamelBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.CamelContextBuildItem;

class DozerProcessor {
    private static final String FEATURE = "camel-dozer";

    DozerProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    JaxbFileRootBuildItem dozerJaxbFileRoot() {
        return new JaxbFileRootBuildItem("com/github/dozermapper/core/builder/model/jaxb");
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem dozerArchiveMarker() {
        return new AdditionalApplicationArchiveMarkerBuildItem("com/github/dozermapper/core");
    }

    @BuildStep(loadsApplicationClasses=true)
    void configureCamelDozer(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> nativeImage, CamelDozerConfig camelDozerConfig) {
        camelDozerConfig.mappingFiles.orElse(Collections.emptyList()).stream().map(this::mappingPathToURI).filter(uri -> uri.getScheme() == null).map(uri -> new NativeImageResourceBuildItem(new String[]{uri.getPath()})).forEach(arg_0 -> nativeImage.produce(arg_0));
        nativeImage.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"dtd/bean-mapping.dtd", "dtd/bean-mapping-6.0.0.dtd", "dtd/bean-mapping-6.2.0.dtd", "schema/bean-mapping.xsd", "schema/bean-mapping-6.0.0.xsd", "schema/bean-mapping-6.2.0.xsd"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{BigDecimal[].class, BigInteger[].class, Boolean[].class, Byte[].class, Calendar[].class, Character[].class, Class[].class, java.util.Date[].class, Date[].class, Double[].class, File[].class, Float[].class, Integer[].class, Long[].class, Object[].class, Short[].class, String[].class, Time[].class, Timestamp[].class, URL[].class, DozerThreadContextClassLoader.class, ExpressionFactoryImpl.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"com.sun.org.apache.xerces.internal.impl.dv.xs.SchemaDVFactoryImpl"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{DozerBeanMapperConfiguration.class}));
        if (camelDozerConfig.mappingFiles.isPresent()) {
            Mapper mapper = DozerBeanMapperBuilder.create().withClassLoader(Thread.currentThread().getContextClassLoader()).withMappingFiles((List)camelDozerConfig.mappingFiles.get()).build();
            mapper.getMappingMetadata().getClassMappings().stream().map(metadata -> new ReflectiveClassBuildItem(true, false, new String[]{metadata.getSourceClassName(), metadata.getDestinationClassName()})).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelBeanBuildItem configureCamelDozerBeanMappings(CamelDozerConfig camelDozerConfig, CamelDozerRecorder camelDozerRecorder) {
        CamelBeanBuildItem camelBeanBuildItem = null;
        if (camelDozerConfig.mappingFiles.isPresent()) {
            camelBeanBuildItem = new CamelBeanBuildItem("dozerBeanMappingConfiguration", DozerBeanMapperConfiguration.class.getName(), camelDozerRecorder.createDozerBeanMapperConfiguration((List)camelDozerConfig.mappingFiles.get()));
        }
        return camelBeanBuildItem;
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void configureDozerTypeConverterRegistry(CamelContextBuildItem camelContextBuildItem, CamelDozerConfig camelDozerConfig, CamelDozerRecorder camelDozerRecorder) {
        if (camelDozerConfig.typeConverterEnabled) {
            camelDozerRecorder.initializeDozerTypeConverter(camelContextBuildItem.getCamelContext());
        }
    }

    private URI mappingPathToURI(String mappingPath) {
        try {
            return new URI(mappingPath);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

