/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.dozer.deployment;

import com.github.dozermapper.core.builder.model.jaxb.AllowedExceptionsDefinition;
import com.github.dozermapper.core.builder.model.jaxb.ClassDefinition;
import com.github.dozermapper.core.builder.model.jaxb.ConfigurationDefinition;
import com.github.dozermapper.core.builder.model.jaxb.ConverterTypeDefinition;
import com.github.dozermapper.core.builder.model.jaxb.CopyByReferencesDefinition;
import com.github.dozermapper.core.builder.model.jaxb.CustomConvertersDefinition;
import com.github.dozermapper.core.builder.model.jaxb.FieldDefinition;
import com.github.dozermapper.core.builder.model.jaxb.FieldDefinitionDefinition;
import com.github.dozermapper.core.builder.model.jaxb.FieldExcludeDefinition;
import com.github.dozermapper.core.builder.model.jaxb.FieldType;
import com.github.dozermapper.core.builder.model.jaxb.MappingDefinition;
import com.github.dozermapper.core.builder.model.jaxb.MappingsDefinition;
import com.github.dozermapper.core.builder.model.jaxb.Relationship;
import com.github.dozermapper.core.builder.model.jaxb.Type;
import com.github.dozermapper.core.builder.model.jaxb.VariableDefinition;
import com.github.dozermapper.core.builder.model.jaxb.VariablesDefinition;
import com.sun.el.ExpressionFactoryImpl;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.camel.component.dozer.CustomMapper;
import org.apache.camel.component.dozer.DozerConfiguration;
import org.apache.camel.component.dozer.ExpressionMapper;
import org.apache.camel.component.dozer.VariableMapper;
import org.apache.camel.converter.dozer.DozerBeanMapperConfiguration;
import org.apache.camel.converter.dozer.DozerThreadContextClassLoader;
import org.apache.camel.quarkus.component.dozer.CamelDozerConfig;
import org.apache.camel.quarkus.component.dozer.CamelDozerRecorder;
import org.apache.camel.quarkus.core.deployment.CamelBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.CamelContextBuildItem;

class DozerProcessor {
    private static final String FEATURE = "camel-dozer";

    DozerProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void configureCamelDozer(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> nativeImage, CamelDozerConfig camelDozerConfig) {
        camelDozerConfig.mappingFiles.stream().map(this::mappingPathToURI).filter(uri -> uri.getScheme() == null).map(uri -> new NativeImageResourceBuildItem(new String[]{uri.getPath()})).forEach(arg_0 -> nativeImage.produce(arg_0));
        nativeImage.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"dtd/bean-mapping.dtd", "dtd/bean-mapping-6.0.0.dtd", "dtd/bean-mapping-6.2.0.dtd", "schema/bean-mapping.xsd", "schema/bean-mapping-6.0.0.xsd", "schema/bean-mapping-6.2.0.xsd", "com/github/dozermapper/core/builder/model/jaxb/jaxb.index"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{BigDecimal[].class, BigInteger[].class, Boolean[].class, Byte[].class, Calendar[].class, Character[].class, Class[].class, java.util.Date[].class, Date[].class, Double[].class, File[].class, Float[].class, Integer[].class, Long[].class, Object[].class, Short[].class, String[].class, Time[].class, Timestamp[].class, URL[].class, DozerThreadContextClassLoader.class, ExpressionFactoryImpl.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"com.github.dozermapper.core.builder.model.jaxb.package-info", "com.sun.org.apache.xerces.internal.impl.dv.xs.SchemaDVFactoryImpl"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{CustomMapper.class, DozerConfiguration.class, ExpressionMapper.class, VariableMapper.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{AllowedExceptionsDefinition.class, ClassDefinition.class, ConfigurationDefinition.class, ConverterTypeDefinition.class, CopyByReferencesDefinition.class, CustomConvertersDefinition.class, FieldDefinition.class, FieldDefinitionDefinition.class, FieldExcludeDefinition.class, FieldType.class, MappingDefinition.class, MappingsDefinition.class, Relationship.class, Type.class, VariableDefinition.class, VariablesDefinition.class}));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelBeanBuildItem configureCamelDozerBeanMappings(CamelDozerConfig camelDozerConfig, CamelDozerRecorder camelDozerRecorder) {
        CamelBeanBuildItem camelBeanBuildItem = null;
        if (!camelDozerConfig.mappingFiles.isEmpty()) {
            camelBeanBuildItem = new CamelBeanBuildItem("dozerBeanMappingConfiguration", DozerBeanMapperConfiguration.class.getName(), camelDozerRecorder.createDozerBeanMapperConfiguration(camelDozerConfig.mappingFiles));
        }
        return camelBeanBuildItem;
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void configureDozerTypeConverterRegistry(CamelContextBuildItem camelContextBuildItem, CamelDozerConfig camelDozerConfig, CamelDozerRecorder camelDozerRecorder) {
        if (camelDozerConfig.typeConverterEnabled) {
            camelDozerRecorder.initializeDozerTypeConverter(camelContextBuildItem.getCamelContext());
        }
    }

    private URI mappingPathToURI(String mappingPath) {
        try {
            return new URI(mappingPath);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

