/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.debug.deployment;

import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AllowJNDIBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import org.apache.camel.quarkus.core.deployment.spi.CamelServiceDestination;
import org.apache.camel.quarkus.core.deployment.spi.CamelServicePatternBuildItem;

class DebugProcessor {
    private static final String FEATURE = "camel-debug";

    DebugProcessor() {
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    AllowJNDIBuildItem allowJNDI() {
        return new AllowJNDIBuildItem();
    }

    @BuildStep(onlyIfNot={IsDevelopment.class})
    CamelServicePatternBuildItem camelDebuggerFactoryServicePattern() {
        return new CamelServicePatternBuildItem(CamelServiceDestination.DISCOVERY, false, new String[]{"META-INF/services/org/apache/camel/debugger-factory"});
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void nativeUnsupported() {
        throw new RuntimeException("The camel-debug extension is not supported in native mode as JMX is not supported on GraalVM");
    }
}

