/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.datasonnet.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

class DatasonnetProcessor {
    private static final String FEATURE = "camel-datasonnet";

    DatasonnetProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("com.datasonnet", "datasonnet-mapper"));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.scala-lang", "scala-library"));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.scala-lang.modules", "scala-collection-compat_2.13"));
    }

    @BuildStep
    void runtimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClass) {
        Stream.of("scala.util.Random$").map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> runtimeInitializedClass.produce(arg_0));
    }

    @BuildStep
    void process(BuildProducer<NativeImageResourceBuildItem> resource) {
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"util.libsonnet"}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerForReflection() {
        ArrayList<ReflectiveClassBuildItem> items = new ArrayList<ReflectiveClassBuildItem>();
        items.add(ReflectiveClassBuildItem.builder((String[])new String[]{"com.datasonnet.jsonnet.Expr[]"}).methods(true).fields(false).build());
        items.add(ReflectiveClassBuildItem.builder((String[])new String[]{"com.datasonnet.jsonnet.Expr$Member$Field[]"}).methods(true).fields(false).build());
        return items;
    }
}

