/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.csimple.deployment;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.JavaCompilationProvider;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.runtime.RuntimeValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.Exchange;
import org.apache.camel.language.csimple.CSimpleCodeGenerator;
import org.apache.camel.language.csimple.CSimpleGeneratedCode;
import org.apache.camel.language.csimple.CSimpleHelper;
import org.apache.camel.language.csimple.CSimpleLanguage;
import org.apache.camel.quarkus.component.csimple.CSimpleLanguageRecorder;
import org.apache.camel.quarkus.component.csimple.deployment.CSimpleExpressionSourceBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelContextBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CompiledCSimpleExpressionBuildItem;
import org.apache.camel.quarkus.core.util.FileUtils;
import org.apache.camel.quarkus.support.language.deployment.ExpressionBuildItem;
import org.apache.camel.quarkus.support.language.deployment.ExpressionExtractionResultBuildItem;
import org.apache.camel.util.PropertiesHelper;
import org.jboss.logging.Logger;

class CSimpleProcessor {
    private static final Logger LOG = Logger.getLogger(CSimpleProcessor.class);
    private static final String CLASS_NAME = "CompiledExpression";
    private static final String PACKAGE_NAME = "org.apache.camel.quarkus.component.csimple.generated";
    static final String CLASS_EXT = ".class";
    private static final String FEATURE = "camel-csimple";

    CSimpleProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void collectCSimpleExpressions(ExpressionExtractionResultBuildItem result, List<ExpressionBuildItem> expressions, BuildProducer<CSimpleExpressionSourceBuildItem> csimpleExpressions) {
        if (result.isSuccess()) {
            int counter = 0;
            for (ExpressionBuildItem expression : expressions) {
                if (!"csimple".equals(expression.getLanguage())) continue;
                csimpleExpressions.produce((BuildItem)new CSimpleExpressionSourceBuildItem(expression.getExpression(), expression.isPredicate(), String.format("%s.%s_%d", PACKAGE_NAME, CLASS_NAME, ++counter)));
            }
        }
    }

    @BuildStep
    void compileCSimpleExpressions(BuildSystemTargetBuildItem buildSystemTargetBuildItem, List<CSimpleExpressionSourceBuildItem> expressionSources, BuildProducer<CompiledCSimpleExpressionBuildItem> compiledCSimpleExpression, BuildProducer<GeneratedClassBuildItem> generatedClasses) throws IOException {
        if (!expressionSources.isEmpty()) {
            TreeSet<String> imports = new TreeSet<String>();
            LinkedHashMap<String, String> aliases = new LinkedHashMap<String, String>();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (!(loader instanceof QuarkusClassLoader)) {
                throw new IllegalStateException(QuarkusClassLoader.class.getSimpleName() + " expected as the context class loader");
            }
            QuarkusClassLoader quarkusClassLoader = (QuarkusClassLoader)loader;
            CSimpleProcessor.readConfig(imports, aliases, loader);
            CSimpleCodeGenerator generator = new CSimpleCodeGenerator();
            generator.setAliases(aliases);
            generator.setImports(imports);
            Path projectDir = Paths.get(".", new String[0]).toAbsolutePath().normalize();
            Path outputDirectory = buildSystemTargetBuildItem.getOutputDirectory();
            Path csimpleGeneratedSourceDir = outputDirectory.resolve("generated/csimple");
            Files.createDirectories(csimpleGeneratedSourceDir, new FileAttribute[0]);
            LinkedHashSet<File> filesToCompile = new LinkedHashSet<File>();
            HashMap compiledExpressions = new HashMap();
            compiledExpressions.put(true, new HashSet());
            compiledExpressions.put(false, new HashSet());
            for (CSimpleExpressionSourceBuildItem expr : expressionSources) {
                boolean predicate = expr.isPredicate();
                String script = expr.getSourceCode();
                if (((Set)compiledExpressions.get(predicate)).contains(script)) continue;
                CSimpleGeneratedCode code = predicate ? generator.generatePredicate(expr.getClassNameBase(), script) : generator.generateExpression(expr.getClassNameBase(), script);
                compiledCSimpleExpression.produce((BuildItem)new CompiledCSimpleExpressionBuildItem(code.getCode(), predicate, code.getFqn()));
                Path javaCsimpleFile = csimpleGeneratedSourceDir.resolve(code.getFqn().replace('.', '/') + ".java");
                Files.createDirectories(javaCsimpleFile.getParent(), new FileAttribute[0]);
                Files.write(javaCsimpleFile, code.getCode().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                filesToCompile.add(javaCsimpleFile.toFile());
                ((Set)compiledExpressions.get(predicate)).add(script);
            }
            Path csimpleClassesDir = outputDirectory.resolve("csimple-classes");
            Files.createDirectories(csimpleClassesDir, new FileAttribute[0]);
            try (JavaCompilationProvider compiler = new JavaCompilationProvider();){
                CompilationProvider.Context context = this.compilationContext(projectDir, csimpleClassesDir, quarkusClassLoader);
                compiler.compile(filesToCompile, context);
            }
            try (Stream<Path> classFiles = Files.walk(csimpleClassesDir, new FileVisitOption[0]);){
                classFiles.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(CLASS_EXT)).forEach(p -> {
                    Path relPath = csimpleClassesDir.relativize((Path)p);
                    String className = FileUtils.nixifyPath((String)relPath.toString());
                    className = className.substring(0, className.length() - CLASS_EXT.length());
                    try {
                        GeneratedClassBuildItem item = new GeneratedClassBuildItem(true, className, Files.readAllBytes(p));
                        generatedClasses.produce((BuildItem)item);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not read " + p);
                    }
                });
            }
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    @Consume(value=CamelContextBuildItem.class)
    CamelBeanBuildItem configureCSimpleLanguage(RecorderContext recorderContext, CSimpleLanguageRecorder recorder, ExpressionExtractionResultBuildItem result, CurateOutcomeBuildItem curateOutcomeBuildItem, List<CompiledCSimpleExpressionBuildItem> compiledCSimpleExpressions) {
        if (result.isSuccess()) {
            RuntimeValue builder = recorder.csimpleLanguageBuilder();
            for (CompiledCSimpleExpressionBuildItem expr : compiledCSimpleExpressions) {
                recorder.addExpression(builder, recorderContext.newInstance(expr.getClassName()));
            }
            RuntimeValue csimpleLanguage = recorder.buildCSimpleLanguage(builder);
            return new CamelBeanBuildItem("csimple", CSimpleLanguage.class.getName(), csimpleLanguage);
        }
        if (curateOutcomeBuildItem.getApplicationModel().getDependencies().stream().noneMatch(x -> x.getGroupId().equals("org.apache.camel") && x.getArtifactId().equals("camel-csimple-joor"))) {
            LOG.warn((Object)"The expression extraction process has been disabled or failed, please add camel-csimple-joor to your classpath to compile the expressions at runtime");
        }
        return null;
    }

    static void readConfig(Set<String> imports, Map<String, String> aliases, ClassLoader cl) throws IOException {
        Enumeration<URL> confiUrls = cl.getResources("camel-csimple.properties");
        while (confiUrls.hasMoreElements()) {
            URL configUrl = confiUrls.nextElement();
            try (BufferedReader r = new BufferedReader(new InputStreamReader(configUrl.openStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = r.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#")) continue;
                    if (line.startsWith("import ")) {
                        imports.add(line);
                        continue;
                    }
                    int eqPos = line.indexOf(61);
                    String key = line.substring(0, eqPos).trim();
                    String value = line.substring(eqPos + 1).trim();
                    aliases.put(key, value);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read from " + configUrl);
            }
        }
    }

    private CompilationProvider.Context compilationContext(Path projectDir, Path csimpleClassesDir, QuarkusClassLoader quarkusClassLoader) {
        Set classPathElements = Stream.of(CSimpleHelper.class, Exchange.class, PropertiesHelper.class).map(clazz -> clazz.getName().replace('.', '/') + CLASS_EXT).flatMap(className -> quarkusClassLoader.getElementsWithResource(className).stream()).map(ClassPathElement::getRoot).filter(Objects::nonNull).map(Path::toFile).collect(Collectors.toSet());
        return new CompilationProvider.Context("csimple-project", classPathElements, classPathElements, projectDir.toFile(), projectDir.resolve("src/main/java").toFile(), csimpleClassesDir.toFile(), StandardCharsets.UTF_8.name(), Collections.emptyMap(), null, "11", "11", Collections.emptyList(), Collections.emptyList());
    }
}

