/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.csimple.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultPackageScanResourceResolver;
import org.apache.camel.quarkus.component.csimple.deployment.CSimpleExpressionSourceBuildItem;
import org.apache.camel.quarkus.core.CamelConfig;
import org.apache.camel.quarkus.core.deployment.LanguageExpressionContentHandler;
import org.apache.camel.quarkus.core.deployment.spi.CamelRoutesBuilderClassBuildItem;
import org.apache.camel.quarkus.core.deployment.util.CamelSupport;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.AntPathMatcher;
import org.jboss.logging.Logger;
import org.xml.sax.helpers.DefaultHandler;

public class CSimpleXmlProcessor {
    private static final Logger LOG = Logger.getLogger(CSimpleXmlProcessor.class);

    @BuildStep
    void collectCSimpleExpresions(CamelConfig config, List<CamelRoutesBuilderClassBuildItem> routesBuilderClasses, BuildProducer<CSimpleExpressionSourceBuildItem> csimpleExpressions, Capabilities capabilities) throws Exception {
        if (capabilities.isCapabilityPresent("org.apache.camel.main")) {
            String[] includes = (String[])Stream.of("camel.main.routesIncludePattern", "camel.main.routes-include-pattern").map(prop -> (String[])CamelSupport.getOptionalConfigValue((String)prop, String[].class, (Object)new String[0])).flatMap(Stream::of).filter(path -> !path.equals("false")).toArray(String[]::new);
            String[] excludes = (String[])Stream.of("camel.main.routesExcludePattern", "camel.main.routes-exclude-pattern").map(prop -> (String[])CamelSupport.getOptionalConfigValue((String)prop, String[].class, (Object)new String[0])).flatMap(Stream::of).filter(path -> !path.equals("false")).toArray(String[]::new);
            try (DefaultPackageScanResourceResolver resolver = new DefaultPackageScanResourceResolver();){
                resolver.setCamelContext((CamelContext)new DefaultCamelContext());
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                saxParserFactory.setNamespaceAware(true);
                SAXParser saxParser = saxParserFactory.newSAXParser();
                for (String include : includes) {
                    for (Resource resource : resolver.findResources(include)) {
                        if (AntPathMatcher.INSTANCE.anyMatch(excludes, resource.getLocation())) continue;
                        try {
                            InputStream is = resource.getInputStream();
                            try {
                                saxParser.parse(is, (DefaultHandler)new LanguageExpressionContentHandler("csimple", (script, isPredicate) -> csimpleExpressions.produce((BuildItem)new CSimpleExpressionSourceBuildItem((String)script, (boolean)isPredicate, "org.apache.camel.language.csimple.XmlRouteBuilder"))));
                            }
                            finally {
                                if (is == null) continue;
                                is.close();
                            }
                        }
                        catch (FileNotFoundException e) {
                            LOG.debugf("No XML routes found in %s. Skipping XML routes detection.", (Object)resource.getLocation());
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Could not analyze CSimple expressions in " + resource.getLocation(), e);
                        }
                    }
                }
            }
        }
    }
}

