/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.csimple.deployment;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.JavaCompilationProvider;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.runtime.RuntimeValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.language.csimple.CSimpleCodeGenerator;
import org.apache.camel.language.csimple.CSimpleGeneratedCode;
import org.apache.camel.language.csimple.CSimpleHelper;
import org.apache.camel.language.csimple.CSimpleLanguage;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.quarkus.component.csimple.CSimpleLanguageRecorder;
import org.apache.camel.quarkus.component.csimple.deployment.CSimpleExpressionSourceBuildItem;
import org.apache.camel.quarkus.core.CamelConfig;
import org.apache.camel.quarkus.core.deployment.LanguageExpressionContentHandler;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelContextBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelRoutesBuilderClassBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CompiledCSimpleExpressionBuildItem;
import org.apache.camel.util.PropertiesHelper;
import org.jboss.logging.Logger;
import org.xml.sax.ContentHandler;

class CSimpleProcessor {
    private static final Logger LOG = Logger.getLogger(CSimpleProcessor.class);
    static final String CLASS_EXT = ".class";
    private static final String FEATURE = "camel-csimple";

    CSimpleProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void collectCSimpleExpresions(CamelConfig config, List<CamelRoutesBuilderClassBuildItem> routesBuilderClasses, BuildProducer<CSimpleExpressionSourceBuildItem> csimpleExpressions) throws IOException, ClassNotFoundException, URISyntaxException, JAXBException {
        if (!routesBuilderClasses.isEmpty()) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (!(loader instanceof QuarkusClassLoader)) {
                throw new IllegalStateException(QuarkusClassLoader.class.getSimpleName() + " expected as the context class loader");
            }
            ExpressionCollector collector = new ExpressionCollector(loader);
            DefaultCamelContext ctx = new DefaultCamelContext();
            for (CamelRoutesBuilderClassBuildItem routesBuilderClass : routesBuilderClasses) {
                String className = routesBuilderClass.getDotName().toString();
                Class<?> cl = loader.loadClass(className);
                if (!RouteBuilder.class.isAssignableFrom(cl)) {
                    LOG.warnf("CSimple language expressions ocurring in %s won't be compiled at build time", cl);
                    continue;
                }
                try {
                    RouteBuilder rb = (RouteBuilder)cl.newInstance();
                    rb.setContext((CamelContext)ctx);
                    try {
                        rb.configure();
                        collector.collect("csimple", (script, isPredicate) -> csimpleExpressions.produce((BuildItem)new CSimpleExpressionSourceBuildItem((String)script, (boolean)isPredicate, className)), new NamedNode[]{rb.getRouteCollection(), rb.getRestCollection()});
                    }
                    catch (Exception e) {
                        switch (config.csimple.onBuildTimeAnalysisFailure) {
                            case fail: {
                                throw new RuntimeException("Could not extract CSimple expressions from " + className + ". You may want to set quarkus.camel.csimple.on-build-time-analysis-failure to warn or ignore if you do not use CSimple language in your routes", e);
                            }
                            case warn: {
                                LOG.warnf((Throwable)e, "Could not extract CSimple language expressions from the route definition %s in class %s.", (Object)rb, cl);
                                break;
                            }
                            case ignore: {
                                LOG.debugf((Throwable)e, "Could not extract CSimple language expressions from the route definition %s in class %s", (Object)rb, cl);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected " + CamelConfig.FailureRemedy.class.getSimpleName() + ": " + config.csimple.onBuildTimeAnalysisFailure);
                            }
                        }
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Could not instantiate " + className, e);
                }
            }
        }
    }

    @BuildStep
    void compileCSimpleExpresions(List<CSimpleExpressionSourceBuildItem> expressionSources, BuildProducer<CompiledCSimpleExpressionBuildItem> compiledCSimpleExpression, BuildProducer<GeneratedClassBuildItem> generatedClasses) throws IOException {
        if (!expressionSources.isEmpty()) {
            TreeSet<String> imports = new TreeSet<String>();
            LinkedHashMap<String, String> aliases = new LinkedHashMap<String, String>();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (!(loader instanceof QuarkusClassLoader)) {
                throw new IllegalStateException(QuarkusClassLoader.class.getSimpleName() + " expected as the context class loader");
            }
            QuarkusClassLoader quarkusClassLoader = (QuarkusClassLoader)loader;
            CSimpleProcessor.readConfig(imports, aliases, loader);
            CSimpleCodeGenerator generator = new CSimpleCodeGenerator();
            generator.setAliases(aliases);
            generator.setImports(imports);
            Path projectDir = Paths.get(".", new String[0]).toAbsolutePath().normalize();
            Path csimpleGeneratedSourceDir = projectDir.resolve("target/generated/csimple");
            Files.createDirectories(csimpleGeneratedSourceDir, new FileAttribute[0]);
            LinkedHashSet<File> filesToCompile = new LinkedHashSet<File>();
            HashMap compiledExpressions = new HashMap();
            compiledExpressions.put(true, new HashSet());
            compiledExpressions.put(false, new HashSet());
            for (CSimpleExpressionSourceBuildItem expr : expressionSources) {
                boolean predicate = expr.isPredicate();
                String script = expr.getSourceCode();
                if (((Set)compiledExpressions.get(predicate)).contains(script)) continue;
                CSimpleGeneratedCode code = predicate ? generator.generatePredicate(expr.getClassNameBase(), script) : generator.generateExpression(expr.getClassNameBase(), script);
                compiledCSimpleExpression.produce((BuildItem)new CompiledCSimpleExpressionBuildItem(code.getCode(), predicate, code.getFqn()));
                Path javaCsimpleFile = csimpleGeneratedSourceDir.resolve(code.getFqn().replace('.', '/') + ".java");
                Files.createDirectories(javaCsimpleFile.getParent(), new FileAttribute[0]);
                Files.write(javaCsimpleFile, code.getCode().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                filesToCompile.add(javaCsimpleFile.toFile());
                ((Set)compiledExpressions.get(predicate)).add(script);
            }
            Path csimpleClassesDir = projectDir.resolve("target/csimple-classes");
            Files.createDirectories(csimpleClassesDir, new FileAttribute[0]);
            try (JavaCompilationProvider compiler = new JavaCompilationProvider();){
                CompilationProvider.Context context = this.compilationContext(projectDir, csimpleClassesDir, quarkusClassLoader);
                compiler.compile(filesToCompile, context);
            }
            try (Stream<Path> classFiles = Files.walk(csimpleClassesDir, new FileVisitOption[0]);){
                classFiles.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(CLASS_EXT)).forEach(p -> {
                    Path relPath = csimpleClassesDir.relativize((Path)p);
                    String className = relPath.toString();
                    className = className.substring(0, className.length() - CLASS_EXT.length());
                    try {
                        GeneratedClassBuildItem item = new GeneratedClassBuildItem(true, className, Files.readAllBytes(p));
                        generatedClasses.produce((BuildItem)item);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not read " + p);
                    }
                });
            }
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelBeanBuildItem configureCSimpleLanguage(RecorderContext recorderContext, CSimpleLanguageRecorder recorder, CamelContextBuildItem camelContext, List<CompiledCSimpleExpressionBuildItem> compiledCSimpleExpressions) {
        RuntimeValue builder = recorder.csimpleLanguageBuilder();
        for (CompiledCSimpleExpressionBuildItem expr : compiledCSimpleExpressions) {
            recorder.addExpression(builder, recorderContext.newInstance(expr.getClassName()));
        }
        RuntimeValue csimpleLanguage = recorder.buildCSimpleLanguage(builder);
        return new CamelBeanBuildItem("csimple", CSimpleLanguage.class.getName(), csimpleLanguage);
    }

    static void readConfig(Set<String> imports, Map<String, String> aliases, ClassLoader cl) throws IOException {
        Enumeration<URL> confiUrls = cl.getResources("camel-csimple.properties");
        while (confiUrls.hasMoreElements()) {
            URL configUrl = confiUrls.nextElement();
            try (BufferedReader r = new BufferedReader(new InputStreamReader(configUrl.openStream(), StandardCharsets.UTF_8));){
                String line = null;
                while ((line = r.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#")) continue;
                    if (line.startsWith("import ")) {
                        imports.add(line);
                        continue;
                    }
                    int eqPos = line.indexOf(61);
                    String key = line.substring(0, eqPos).trim();
                    String value = line.substring(eqPos + 1).trim();
                    aliases.put(key, value);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read from " + configUrl);
            }
        }
    }

    private CompilationProvider.Context compilationContext(Path projectDir, Path csimpleClassesDir, QuarkusClassLoader quarkusClassLoader) {
        Set classPathElements = Stream.of(CSimpleHelper.class, Exchange.class, PropertiesHelper.class).map(clazz -> clazz.getName().replace('.', '/') + CLASS_EXT).flatMap(className -> quarkusClassLoader.getElementsWithResource(className).stream()).map(cpe -> cpe.getRoot()).filter(p -> p != null).map(Path::toFile).collect(Collectors.toSet());
        return new CompilationProvider.Context("csimple-project", classPathElements, projectDir.toFile(), projectDir.resolve("src/main/java").toFile(), csimpleClassesDir.toFile(), StandardCharsets.UTF_8.name(), Collections.emptyList(), "1.8", "1.8", Collections.emptyList(), Collections.emptyList());
    }

    static class ExpressionCollector {
        private final JAXBContext jaxbContext;
        private final Marshaller marshaler;

        ExpressionCollector(ClassLoader loader) {
            try {
                this.jaxbContext = JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.cloud:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.model.rest:org.apache.camel.model.transformer:org.apache.camel.model.validator", (ClassLoader)loader);
                Marshaller m = this.jaxbContext.createMarshaller();
                m.setListener((Marshaller.Listener)new RouteDefinitionNormalizer());
                this.marshaler = m;
            }
            catch (JAXBException e) {
                throw new RuntimeException("Could not creat a JAXB marshaler", e);
            }
        }

        public void collect(String languageName, BiConsumer<String, Boolean> expressionConsumer, NamedNode ... nodes) {
            LanguageExpressionContentHandler handler = new LanguageExpressionContentHandler(languageName, expressionConsumer);
            for (NamedNode node : nodes) {
                try {
                    this.marshaler.marshal((Object)node, (ContentHandler)handler);
                }
                catch (JAXBException e) {
                    throw new RuntimeException("Could not collect '" + languageName + "' expressions from node " + node, e);
                }
            }
        }

        private static class RouteDefinitionNormalizer
        extends Marshaller.Listener {
            private RouteDefinitionNormalizer() {
            }

            public void beforeMarshal(Object source) {
                if (source instanceof ExpressionNode) {
                    ((ExpressionNode)source).preCreateProcessor();
                }
            }
        }
    }
}

