/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.k.tooling.maven;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.models.openapi.OpenApiDocument;
import io.apicurio.datamodels.models.util.JsonUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.CamelContext;
import org.apache.camel.generator.openapi.RestDslXmlGenerator;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-rest-xml", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=false, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
class GenerateRestXML
extends AbstractMojo {
    @Parameter(property="openapi.spec")
    private String inputFile;
    @Parameter(property="dsl.out")
    private String outputFile;

    GenerateRestXML() {
    }

    public void execute() throws MojoExecutionException {
        if (this.inputFile == null) {
            throw new MojoExecutionException("Missing input file: " + this.inputFile);
        }
        Path input = Paths.get(this.inputFile, new String[0]);
        if (!Files.exists(input, new LinkOption[0])) {
            throw new MojoExecutionException("Unable to read the input file: " + this.inputFile);
        }
        try {
            Writer writer;
            YAMLFactory factory = null;
            if (this.inputFile.endsWith(".yaml") || this.inputFile.endsWith(".yml")) {
                factory = new YAMLFactory();
            }
            ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
            mapper.findAndRegisterModules();
            FileInputStream fis = new FileInputStream(this.inputFile);
            JsonNode node = mapper.readTree((InputStream)fis);
            OpenApiDocument document = (OpenApiDocument)Library.readDocument((ObjectNode)JsonUtil.toObject((JsonNode)node));
            if (this.outputFile != null) {
                Path output = Paths.get(this.outputFile, new String[0]);
                if (output.getParent() != null && Files.notExists(output.getParent(), new LinkOption[0])) {
                    Files.createDirectories(output.getParent(), new FileAttribute[0]);
                }
                if (Files.exists(output, new LinkOption[0])) {
                    Files.delete(output);
                }
                writer = Files.newBufferedWriter(output, new OpenOption[0]);
            } else {
                writer = new PrintWriter(System.out);
            }
            DefaultCamelContext context = new DefaultCamelContext();
            String dsl = RestDslXmlGenerator.toXml((OpenApiDocument)document).generate((CamelContext)context);
            try (PrintWriter printWriter = writer;){
                ((Writer)writer).write(dsl);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception while generating rest xml", e);
        }
    }
}

