/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.caffeine.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import java.util.function.BooleanSupplier;
import org.apache.camel.quarkus.core.deployment.util.CamelSupport;

class CaffeineProcessor {
    private static final String FEATURE = "camel-caffeine";

    CaffeineProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={CamelCaffeineStatsEnabled.class})
    NativeImageSystemPropertyBuildItem registerRecordStatsImplementations() {
        return new NativeImageSystemPropertyBuildItem("io.quarkus.caffeine.graalvm.recordStats", "true");
    }

    static final class CamelCaffeineStatsEnabled
    implements BooleanSupplier {
        CamelCaffeineStatsEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return (Boolean)CamelSupport.getOptionalConfigValue((String)"camel.component.caffeine-cache.stats-enabled", Boolean.TYPE, (Object)false) != false || (Boolean)CamelSupport.getOptionalConfigValue((String)"camel.component.caffeine-cache.statsEnabled", Boolean.TYPE, (Object)false) != false;
        }
    }
}

