/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.braintree.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.apache.camel.component.braintree.BraintreeComponent;
import org.apache.camel.quarkus.component.braintree.graal.BraintreeRecorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;

class BraintreeProcessor {
    private static final String FEATURE = "camel-braintree";

    BraintreeProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.braintreegateway.Address", "com.braintreegateway.BraintreeGateway", "com.braintreegateway.Customer", "com.braintreegateway.DisputeEvidence", "com.braintreegateway.DocumentUpload", "com.braintreegateway.MerchantAccount", "com.braintreegateway.PaymentMethod", "com.braintreegateway.Transaction"}).methods().build());
    }

    @BuildStep
    void nativeImageResources(BuildProducer<NativeImageResourceBuildItem> nativeImage) {
        nativeImage.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"ssl/api_braintreegateway_com.ca.crt", "ssl/payments_braintreeapi_com.ca.crt"}));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelBeanBuildItem configureBraintreeComponent(BraintreeRecorder recorder) {
        return new CamelBeanBuildItem("braintree", BraintreeComponent.class.getName(), recorder.configureBraintreeComponent());
    }
}

