/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bindy.deployment;

import com.ibm.icu.util.VersionInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceDirectoryBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.stream.Stream;
import org.apache.camel.dataformat.bindy.annotation.BindyConverter;
import org.apache.camel.dataformat.bindy.annotation.CsvRecord;
import org.apache.camel.dataformat.bindy.annotation.DataField;
import org.apache.camel.dataformat.bindy.annotation.FixedLengthRecord;
import org.apache.camel.dataformat.bindy.annotation.FormatFactories;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.annotation.Message;
import org.apache.camel.dataformat.bindy.annotation.OneToMany;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class BindyProcessor {
    private static final Logger LOG = Logger.getLogger(BindyProcessor.class);
    private static final String FEATURE = "camel-bindy";

    BindyProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    NativeImageResourceDirectoryBuildItem resourceBundles() {
        String resourcePath = String.format("com/ibm/icu/impl/data/icudt%db/brkitr", VersionInfo.ICU_VERSION.getMajor());
        return new NativeImageResourceDirectoryBuildItem(resourcePath);
    }

    @BuildStep
    void registerReflectiveClasses(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> producer) {
        producer.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"com.ibm.icu.text.BreakIteratorFactory"}));
        IndexView idx = index.getIndex();
        Stream.of(CsvRecord.class, FixedLengthRecord.class, Message.class).map(clazz -> DotName.createSimple((String)clazz.getName())).flatMap(dotName -> idx.getAnnotations(dotName).stream()).filter(anno -> anno.target() != null && anno.target().kind() == AnnotationTarget.Kind.CLASS).map(anno -> anno.target().asClass().name().toString()).forEach(className -> {
            LOG.debugf("Registering root model class as reflective: %s", className);
            producer.produce((BuildItem)new ReflectiveClassBuildItem(false, true, new String[]{className}));
        });
        Stream.of(Link.class).map(clazz -> DotName.createSimple((String)clazz.getName())).flatMap(dotName -> idx.getAnnotations(dotName).stream()).filter(anno -> anno.target() != null && anno.target().kind() == AnnotationTarget.Kind.FIELD).forEach(anno -> {
            String className = anno.target().asField().type().name().toString();
            LOG.debugf("Registering @Link model class as reflective: %s", (Object)className);
            producer.produce((BuildItem)new ReflectiveClassBuildItem(false, true, new String[]{className}));
        });
        Stream.of(OneToMany.class).map(clazz -> DotName.createSimple((String)clazz.getName())).flatMap(dotName -> idx.getAnnotations(dotName).stream()).filter(anno -> anno.target() != null && anno.target().kind() == AnnotationTarget.Kind.FIELD).filter(anno -> anno.target().asField().type().kind() == Type.Kind.PARAMETERIZED_TYPE).forEach(anno -> {
            ParameterizedType fieldType = anno.target().asField().type().asParameterizedType();
            if (fieldType.arguments().size() >= 1) {
                String className = ((Type)fieldType.arguments().get(0)).name().toString();
                LOG.debugf("Registering @OneToMany model class as reflective: %s", (Object)className);
                producer.produce((BuildItem)new ReflectiveClassBuildItem(false, true, new String[]{className}));
            }
        });
        Stream.of(BindyConverter.class).map(clazz -> DotName.createSimple((String)clazz.getName())).flatMap(dotName -> idx.getAnnotations(dotName).stream()).forEach(anno -> {
            String className = anno.value().asClass().name().toString();
            LOG.debugf("Registering @BindyConverter class as reflective: %s", (Object)className);
            producer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{className}));
        });
        Stream.of(FormatFactories.class).map(clazz -> DotName.createSimple((String)clazz.getName())).flatMap(dotName -> idx.getAnnotations(dotName).stream()).forEach(anno -> {
            for (Type t : anno.value().asClassArray()) {
                LOG.debugf("Registering @FormatFactories class as reflective: %s", (Object)t.name().toString());
                producer.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{t.name().toString()}));
            }
        });
        Stream.of(DataField.class).map(clazz -> DotName.createSimple((String)clazz.getName())).flatMap(dotName -> idx.getAnnotations(dotName).stream()).filter(anno -> anno.value("method") != null && !anno.value("method").asString().isEmpty()).filter(anno -> anno.target() != null && anno.target().kind() == AnnotationTarget.Kind.FIELD).forEach(anno -> {
            String method = anno.value("method").asString();
            String methodClazz = method.contains(".") ? method.substring(0, method.lastIndexOf(46)) : anno.target().asField().type().toString();
            LOG.debugf("Registering @DataField.method() class as reflective: %s", (Object)methodClazz);
            producer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{methodClazz}));
        });
    }
}

