/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.storage.queue.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

class AzureStorageQueueProcessor {
    private static final Logger LOG = Logger.getLogger(AzureStorageQueueProcessor.class);
    private static final String FEATURE = "camel-azure-storage-queue";

    AzureStorageQueueProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    void reflectiveClasses(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        String[] modelClasses = (String[])combinedIndex.getIndex().getKnownClasses().stream().map(ClassInfo::name).map(DotName::toString).filter(n -> n.startsWith("com.azure.storage.queue.implementation.models.") || n.startsWith("com.azure.storage.queue.models.")).sorted().toArray(String[]::new);
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, true, modelClasses));
    }

    @BuildStep
    IndexDependencyBuildItem indexDependency() {
        return new IndexDependencyBuildItem("com.azure", "azure-storage-queue");
    }
}

