/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.kms.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;

class Aws2KmsProcessor {
    private static final String FEATURE = "camel-aws2-kms";
    public static final String AWS_SDK_APPLICATION_ARCHIVE_MARKERS = "software/amazon/awssdk";
    private static final List<String> INTERCEPTOR_PATHS = Arrays.asList("software/amazon/awssdk/global/handlers/execution.interceptors");
    private static final DotName EXECUTION_INTERCEPTOR_NAME = DotName.createSimple((String)ExecutionInterceptor.class.getName());

    Aws2KmsProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void process(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<NativeImageResourceBuildItem> resource) {
        INTERCEPTOR_PATHS.forEach(path -> resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{path})));
        List<String> knownInterceptorImpls = combinedIndexBuildItem.getIndex().getAllKnownImplementors(EXECUTION_INTERCEPTOR_NAME).stream().map(c -> c.name().toString()).collect(Collectors.toList());
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, knownInterceptorImpls.toArray(new String[knownInterceptorImpls.size()])));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{String.class.getCanonicalName()}));
    }

    @BuildStep
    void archiveMarkers(BuildProducer<AdditionalApplicationArchiveMarkerBuildItem> archiveMarkers) {
        archiveMarkers.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem(AWS_SDK_APPLICATION_ARCHIVE_MARKERS));
    }
}

