/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws.s3.deployment;

import com.amazonaws.partitions.model.CredentialScope;
import com.amazonaws.partitions.model.Endpoint;
import com.amazonaws.partitions.model.Partition;
import com.amazonaws.partitions.model.Partitions;
import com.amazonaws.partitions.model.Region;
import com.amazonaws.partitions.model.Service;
import com.amazonaws.services.s3.internal.AWSS3V4Signer;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ServiceProviderBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBundleBuildItem;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.camel.component.aws.s3.S3Configuration;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class AwsS3Processor {
    public static final String AWS_S3_APPLICATION_ARCHIVE_MARKERS = "com/amazonaws";
    private static final String FEATURE = "camel-aws-s3";

    AwsS3Processor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    RuntimeInitializedClassBuildItem cryptoConfiguration() {
        return new RuntimeInitializedClassBuildItem(CryptoConfiguration.class.getCanonicalName());
    }

    @BuildStep
    SubstrateProxyDefinitionBuildItem httpProxies() {
        return new SubstrateProxyDefinitionBuildItem(new String[]{"org.apache.http.conn.HttpClientConnectionManager", "org.apache.http.pool.ConnPoolControl", "com.amazonaws.http.conn.Wrapped"});
    }

    @BuildStep(applicationArchiveMarkers={"com/amazonaws"})
    void process(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethod, BuildProducer<SubstrateResourceBuildItem> resource, BuildProducer<SubstrateResourceBundleBuildItem> resourceBundle, BuildProducer<ServiceProviderBuildItem> serviceProvider, ApplicationArchivesBuildItem applicationArchivesBuildItem) {
        IndexView view = combinedIndexBuildItem.getIndex();
        resource.produce((BuildItem)new SubstrateResourceBuildItem(new String[]{"com/amazonaws/partitions/endpoints.json"}));
        for (String s : this.getImplementations(view, JsonDeserializer.class)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{s}));
        }
        for (String s : this.getImplementations(view, JsonSerializer.class)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{s}));
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{Partitions.class.getCanonicalName(), Partition.class.getCanonicalName(), Endpoint.class.getCanonicalName(), Region.class.getCanonicalName(), Service.class.getCanonicalName(), CredentialScope.class.getCanonicalName(), LogFactoryImpl.class.getCanonicalName(), Jdk14Logger.class.getCanonicalName(), AWSS3V4Signer.class.getCanonicalName(), S3Configuration.class.getCanonicalName()}));
    }

    protected Collection<String> getImplementations(IndexView view, Class<?> type) {
        return view.getAllKnownImplementors(DotName.createSimple((String)type.getName())).stream().map(ClassInfo::toString).collect(Collectors.toList());
    }
}

