/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws.kms.deployment;

import com.amazonaws.partitions.model.CredentialScope;
import com.amazonaws.partitions.model.Endpoint;
import com.amazonaws.partitions.model.Partition;
import com.amazonaws.partitions.model.Partitions;
import com.amazonaws.partitions.model.Region;
import com.amazonaws.partitions.model.Service;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;

class AwsKmsProcessor {
    public static final String AWS_KMS_APPLICATION_ARCHIVE_MARKERS = "com/amazonaws";
    private static final String FEATURE = "camel-aws-kms";

    AwsKmsProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep(applicationArchiveMarkers={"com/amazonaws"})
    void process(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> resource) {
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"com/amazonaws/partitions/endpoints.json"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{Partitions.class.getCanonicalName(), Partition.class.getCanonicalName(), Endpoint.class.getCanonicalName(), Region.class.getCanonicalName(), Service.class.getCanonicalName(), CredentialScope.class.getCanonicalName()}));
    }
}

