/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws.kms.deployment;

import com.amazonaws.partitions.model.CredentialScope;
import com.amazonaws.partitions.model.Endpoint;
import com.amazonaws.partitions.model.Partition;
import com.amazonaws.partitions.model.Partitions;
import com.amazonaws.partitions.model.Region;
import com.amazonaws.partitions.model.Service;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.camel.component.aws.kms.KMSConfiguration;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class AwsKmsProcessor {
    public static final String AWS_KMS_APPLICATION_ARCHIVE_MARKERS = "com/amazonaws";
    private static final String FEATURE = "camel-aws-kms";

    AwsKmsProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    NativeImageProxyDefinitionBuildItem httpProxies() {
        return new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.http.conn.HttpClientConnectionManager", "org.apache.http.pool.ConnPoolControl", "com.amazonaws.http.conn.Wrapped"});
    }

    @BuildStep(applicationArchiveMarkers={"com/amazonaws"})
    void process(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> resource) {
        IndexView view = combinedIndexBuildItem.getIndex();
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"com/amazonaws/partitions/endpoints.json"}));
        for (String s : this.getImplementations(view, JsonDeserializer.class)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{s}));
        }
        for (String s : this.getImplementations(view, JsonSerializer.class)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{s}));
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{Partitions.class.getCanonicalName(), Partition.class.getCanonicalName(), Endpoint.class.getCanonicalName(), Region.class.getCanonicalName(), Service.class.getCanonicalName(), CredentialScope.class.getCanonicalName(), KMSConfiguration.class.getCanonicalName()}));
    }

    protected Collection<String> getImplementations(IndexView view, Class<?> type) {
        return view.getAllKnownImplementors(DotName.createSimple((String)type.getName())).stream().map(ClassInfo::toString).collect(Collectors.toList());
    }
}

